/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for using an Batch job as a target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipeTargetBatchJobParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<PipeTargetBatchJobParameters.Builder, PipeTargetBatchJobParameters> {
    private static final SdkField<String> JOB_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobDefinition").getter(getter(PipeTargetBatchJobParameters::jobDefinition))
            .setter(setter(Builder::jobDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinition").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(PipeTargetBatchJobParameters::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<BatchArrayProperties> ARRAY_PROPERTIES_FIELD = SdkField
            .<BatchArrayProperties> builder(MarshallingType.SDK_POJO).memberName("ArrayProperties")
            .getter(getter(PipeTargetBatchJobParameters::arrayProperties)).setter(setter(Builder::arrayProperties))
            .constructor(BatchArrayProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArrayProperties").build()).build();

    private static final SdkField<BatchRetryStrategy> RETRY_STRATEGY_FIELD = SdkField
            .<BatchRetryStrategy> builder(MarshallingType.SDK_POJO).memberName("RetryStrategy")
            .getter(getter(PipeTargetBatchJobParameters::retryStrategy)).setter(setter(Builder::retryStrategy))
            .constructor(BatchRetryStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryStrategy").build()).build();

    private static final SdkField<BatchContainerOverrides> CONTAINER_OVERRIDES_FIELD = SdkField
            .<BatchContainerOverrides> builder(MarshallingType.SDK_POJO).memberName("ContainerOverrides")
            .getter(getter(PipeTargetBatchJobParameters::containerOverrides)).setter(setter(Builder::containerOverrides))
            .constructor(BatchContainerOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerOverrides").build())
            .build();

    private static final SdkField<List<BatchJobDependency>> DEPENDS_ON_FIELD = SdkField
            .<List<BatchJobDependency>> builder(MarshallingType.LIST)
            .memberName("DependsOn")
            .getter(getter(PipeTargetBatchJobParameters::dependsOn))
            .setter(setter(Builder::dependsOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependsOn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchJobDependency> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchJobDependency::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(PipeTargetBatchJobParameters::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_FIELD,
            JOB_NAME_FIELD, ARRAY_PROPERTIES_FIELD, RETRY_STRATEGY_FIELD, CONTAINER_OVERRIDES_FIELD, DEPENDS_ON_FIELD,
            PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jobDefinition;

    private final String jobName;

    private final BatchArrayProperties arrayProperties;

    private final BatchRetryStrategy retryStrategy;

    private final BatchContainerOverrides containerOverrides;

    private final List<BatchJobDependency> dependsOn;

    private final Map<String, String> parameters;

    private PipeTargetBatchJobParameters(BuilderImpl builder) {
        this.jobDefinition = builder.jobDefinition;
        this.jobName = builder.jobName;
        this.arrayProperties = builder.arrayProperties;
        this.retryStrategy = builder.retryStrategy;
        this.containerOverrides = builder.containerOverrides;
        this.dependsOn = builder.dependsOn;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The job definition used by this job. This value can be one of <code>name</code>, <code>name:revision</code>, or
     * the Amazon Resource Name (ARN) for the job definition. If name is specified without a revision then the latest
     * active revision is used.
     * </p>
     * 
     * @return The job definition used by this job. This value can be one of <code>name</code>,
     *         <code>name:revision</code>, or the Amazon Resource Name (ARN) for the job definition. If name is
     *         specified without a revision then the latest active revision is used.
     */
    public final String jobDefinition() {
        return jobDefinition;
    }

    /**
     * <p>
     * The name of the job. It can be up to 128 letters long. The first character must be alphanumeric, can contain
     * uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
     * </p>
     * 
     * @return The name of the job. It can be up to 128 letters long. The first character must be alphanumeric, can
     *         contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The array properties for the submitted job, such as the size of the array. The array size can be between 2 and
     * 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the
     * target is an Batch job.
     * </p>
     * 
     * @return The array properties for the submitted job, such as the size of the array. The array size can be between
     *         2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used
     *         only if the target is an Batch job.
     */
    public final BatchArrayProperties arrayProperties() {
        return arrayProperties;
    }

    /**
     * <p>
     * The retry strategy to use for failed jobs. When a retry strategy is specified here, it overrides the retry
     * strategy defined in the job definition.
     * </p>
     * 
     * @return The retry strategy to use for failed jobs. When a retry strategy is specified here, it overrides the
     *         retry strategy defined in the job definition.
     */
    public final BatchRetryStrategy retryStrategy() {
        return retryStrategy;
    }

    /**
     * <p>
     * The overrides that are sent to a container.
     * </p>
     * 
     * @return The overrides that are sent to a container.
     */
    public final BatchContainerOverrides containerOverrides() {
        return containerOverrides;
    }

    /**
     * For responses, this returns true if the service returned a value for the DependsOn property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDependsOn() {
        return dependsOn != null && !(dependsOn instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
     * <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child array job
     * completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type dependency with a
     * job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of
     * each dependency to complete before it can begin.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDependsOn} method.
     * </p>
     * 
     * @return A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
     *         <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child
     *         array job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type
     *         dependency with a job ID for array jobs. In that case, each index child of this job must wait for the
     *         corresponding index child of each dependency to complete before it can begin.
     */
    public final List<BatchJobDependency> dependsOn() {
        return dependsOn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job
     * definition. Parameters are specified as a key and value pair mapping. Parameters included here override any
     * corresponding parameter defaults from the job definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return Additional parameters passed to the job that replace parameter substitution placeholders that are set in
     *         the job definition. Parameters are specified as a key and value pair mapping. Parameters included here
     *         override any corresponding parameter defaults from the job definition.
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(arrayProperties());
        hashCode = 31 * hashCode + Objects.hashCode(retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(containerOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(hasDependsOn() ? dependsOn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeTargetBatchJobParameters)) {
            return false;
        }
        PipeTargetBatchJobParameters other = (PipeTargetBatchJobParameters) obj;
        return Objects.equals(jobDefinition(), other.jobDefinition()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(arrayProperties(), other.arrayProperties())
                && Objects.equals(retryStrategy(), other.retryStrategy())
                && Objects.equals(containerOverrides(), other.containerOverrides()) && hasDependsOn() == other.hasDependsOn()
                && Objects.equals(dependsOn(), other.dependsOn()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipeTargetBatchJobParameters").add("JobDefinition", jobDefinition()).add("JobName", jobName())
                .add("ArrayProperties", arrayProperties()).add("RetryStrategy", retryStrategy())
                .add("ContainerOverrides", containerOverrides()).add("DependsOn", hasDependsOn() ? dependsOn() : null)
                .add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobDefinition":
            return Optional.ofNullable(clazz.cast(jobDefinition()));
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "ArrayProperties":
            return Optional.ofNullable(clazz.cast(arrayProperties()));
        case "RetryStrategy":
            return Optional.ofNullable(clazz.cast(retryStrategy()));
        case "ContainerOverrides":
            return Optional.ofNullable(clazz.cast(containerOverrides()));
        case "DependsOn":
            return Optional.ofNullable(clazz.cast(dependsOn()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobDefinition", JOB_DEFINITION_FIELD);
        map.put("JobName", JOB_NAME_FIELD);
        map.put("ArrayProperties", ARRAY_PROPERTIES_FIELD);
        map.put("RetryStrategy", RETRY_STRATEGY_FIELD);
        map.put("ContainerOverrides", CONTAINER_OVERRIDES_FIELD);
        map.put("DependsOn", DEPENDS_ON_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipeTargetBatchJobParameters, T> g) {
        return obj -> g.apply((PipeTargetBatchJobParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipeTargetBatchJobParameters> {
        /**
         * <p>
         * The job definition used by this job. This value can be one of <code>name</code>, <code>name:revision</code>,
         * or the Amazon Resource Name (ARN) for the job definition. If name is specified without a revision then the
         * latest active revision is used.
         * </p>
         * 
         * @param jobDefinition
         *        The job definition used by this job. This value can be one of <code>name</code>,
         *        <code>name:revision</code>, or the Amazon Resource Name (ARN) for the job definition. If name is
         *        specified without a revision then the latest active revision is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinition(String jobDefinition);

        /**
         * <p>
         * The name of the job. It can be up to 128 letters long. The first character must be alphanumeric, can contain
         * uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
         * </p>
         * 
         * @param jobName
         *        The name of the job. It can be up to 128 letters long. The first character must be alphanumeric, can
         *        contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The array properties for the submitted job, such as the size of the array. The array size can be between 2
         * and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only
         * if the target is an Batch job.
         * </p>
         * 
         * @param arrayProperties
         *        The array properties for the submitted job, such as the size of the array. The array size can be
         *        between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This
         *        parameter is used only if the target is an Batch job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayProperties(BatchArrayProperties arrayProperties);

        /**
         * <p>
         * The array properties for the submitted job, such as the size of the array. The array size can be between 2
         * and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only
         * if the target is an Batch job.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchArrayProperties.Builder} avoiding
         * the need to create one manually via {@link BatchArrayProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchArrayProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #arrayProperties(BatchArrayProperties)}.
         * 
         * @param arrayProperties
         *        a consumer that will call methods on {@link BatchArrayProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arrayProperties(BatchArrayProperties)
         */
        default Builder arrayProperties(Consumer<BatchArrayProperties.Builder> arrayProperties) {
            return arrayProperties(BatchArrayProperties.builder().applyMutation(arrayProperties).build());
        }

        /**
         * <p>
         * The retry strategy to use for failed jobs. When a retry strategy is specified here, it overrides the retry
         * strategy defined in the job definition.
         * </p>
         * 
         * @param retryStrategy
         *        The retry strategy to use for failed jobs. When a retry strategy is specified here, it overrides the
         *        retry strategy defined in the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryStrategy(BatchRetryStrategy retryStrategy);

        /**
         * <p>
         * The retry strategy to use for failed jobs. When a retry strategy is specified here, it overrides the retry
         * strategy defined in the job definition.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchRetryStrategy.Builder} avoiding the
         * need to create one manually via {@link BatchRetryStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchRetryStrategy.Builder#build()} is called immediately and its
         * result is passed to {@link #retryStrategy(BatchRetryStrategy)}.
         * 
         * @param retryStrategy
         *        a consumer that will call methods on {@link BatchRetryStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryStrategy(BatchRetryStrategy)
         */
        default Builder retryStrategy(Consumer<BatchRetryStrategy.Builder> retryStrategy) {
            return retryStrategy(BatchRetryStrategy.builder().applyMutation(retryStrategy).build());
        }

        /**
         * <p>
         * The overrides that are sent to a container.
         * </p>
         * 
         * @param containerOverrides
         *        The overrides that are sent to a container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerOverrides(BatchContainerOverrides containerOverrides);

        /**
         * <p>
         * The overrides that are sent to a container.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchContainerOverrides.Builder} avoiding
         * the need to create one manually via {@link BatchContainerOverrides#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchContainerOverrides.Builder#build()} is called immediately
         * and its result is passed to {@link #containerOverrides(BatchContainerOverrides)}.
         * 
         * @param containerOverrides
         *        a consumer that will call methods on {@link BatchContainerOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerOverrides(BatchContainerOverrides)
         */
        default Builder containerOverrides(Consumer<BatchContainerOverrides.Builder> containerOverrides) {
            return containerOverrides(BatchContainerOverrides.builder().applyMutation(containerOverrides).build());
        }

        /**
         * <p>
         * A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
         * <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child array
         * job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type dependency
         * with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding
         * index child of each dependency to complete before it can begin.
         * </p>
         * 
         * @param dependsOn
         *        A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
         *        <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child
         *        array job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code>
         *        type dependency with a job ID for array jobs. In that case, each index child of this job must wait for
         *        the corresponding index child of each dependency to complete before it can begin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(Collection<BatchJobDependency> dependsOn);

        /**
         * <p>
         * A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
         * <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child array
         * job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type dependency
         * with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding
         * index child of each dependency to complete before it can begin.
         * </p>
         * 
         * @param dependsOn
         *        A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
         *        <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child
         *        array job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code>
         *        type dependency with a job ID for array jobs. In that case, each index child of this job must wait for
         *        the corresponding index child of each dependency to complete before it can begin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(BatchJobDependency... dependsOn);

        /**
         * <p>
         * A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
         * <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child array
         * job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type dependency
         * with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding
         * index child of each dependency to complete before it can begin.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pipes.model.BatchJobDependency.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.pipes.model.BatchJobDependency#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pipes.model.BatchJobDependency.Builder#build()} is called immediately
         * and its result is passed to {@link #dependsOn(List<BatchJobDependency>)}.
         * 
         * @param dependsOn
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pipes.model.BatchJobDependency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dependsOn(java.util.Collection<BatchJobDependency>)
         */
        Builder dependsOn(Consumer<BatchJobDependency.Builder>... dependsOn);

        /**
         * <p>
         * Additional parameters passed to the job that replace parameter substitution placeholders that are set in the
         * job definition. Parameters are specified as a key and value pair mapping. Parameters included here override
         * any corresponding parameter defaults from the job definition.
         * </p>
         * 
         * @param parameters
         *        Additional parameters passed to the job that replace parameter substitution placeholders that are set
         *        in the job definition. Parameters are specified as a key and value pair mapping. Parameters included
         *        here override any corresponding parameter defaults from the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);
    }

    static final class BuilderImpl implements Builder {
        private String jobDefinition;

        private String jobName;

        private BatchArrayProperties arrayProperties;

        private BatchRetryStrategy retryStrategy;

        private BatchContainerOverrides containerOverrides;

        private List<BatchJobDependency> dependsOn = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PipeTargetBatchJobParameters model) {
            jobDefinition(model.jobDefinition);
            jobName(model.jobName);
            arrayProperties(model.arrayProperties);
            retryStrategy(model.retryStrategy);
            containerOverrides(model.containerOverrides);
            dependsOn(model.dependsOn);
            parameters(model.parameters);
        }

        public final String getJobDefinition() {
            return jobDefinition;
        }

        public final void setJobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
        }

        @Override
        public final Builder jobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final BatchArrayProperties.Builder getArrayProperties() {
            return arrayProperties != null ? arrayProperties.toBuilder() : null;
        }

        public final void setArrayProperties(BatchArrayProperties.BuilderImpl arrayProperties) {
            this.arrayProperties = arrayProperties != null ? arrayProperties.build() : null;
        }

        @Override
        public final Builder arrayProperties(BatchArrayProperties arrayProperties) {
            this.arrayProperties = arrayProperties;
            return this;
        }

        public final BatchRetryStrategy.Builder getRetryStrategy() {
            return retryStrategy != null ? retryStrategy.toBuilder() : null;
        }

        public final void setRetryStrategy(BatchRetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        @Override
        public final Builder retryStrategy(BatchRetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final BatchContainerOverrides.Builder getContainerOverrides() {
            return containerOverrides != null ? containerOverrides.toBuilder() : null;
        }

        public final void setContainerOverrides(BatchContainerOverrides.BuilderImpl containerOverrides) {
            this.containerOverrides = containerOverrides != null ? containerOverrides.build() : null;
        }

        @Override
        public final Builder containerOverrides(BatchContainerOverrides containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        public final List<BatchJobDependency.Builder> getDependsOn() {
            List<BatchJobDependency.Builder> result = BatchDependsOnCopier.copyToBuilder(this.dependsOn);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependsOn(Collection<BatchJobDependency.BuilderImpl> dependsOn) {
            this.dependsOn = BatchDependsOnCopier.copyFromBuilder(dependsOn);
        }

        @Override
        public final Builder dependsOn(Collection<BatchJobDependency> dependsOn) {
            this.dependsOn = BatchDependsOnCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(BatchJobDependency... dependsOn) {
            dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(Consumer<BatchJobDependency.Builder>... dependsOn) {
            dependsOn(Stream.of(dependsOn).map(c -> BatchJobDependency.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = BatchParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = BatchParametersMapCopier.copy(parameters);
            return this;
        }

        @Override
        public PipeTargetBatchJobParameters build() {
            return new PipeTargetBatchJobParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
