/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pipes.model.DeadLetterConfig;
import software.amazon.awssdk.services.pipes.model.KinesisStreamStartPosition;
import software.amazon.awssdk.services.pipes.model.OnPartialBatchItemFailureStreams;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipeSourceKinesisStreamParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipeSourceKinesisStreamParameters> {
    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BatchSize").getter(PipeSourceKinesisStreamParameters.getter(PipeSourceKinesisStreamParameters::batchSize)).setter(PipeSourceKinesisStreamParameters.setter(Builder::batchSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()}).build();
    private static final SdkField<DeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeadLetterConfig").getter(PipeSourceKinesisStreamParameters.getter(PipeSourceKinesisStreamParameters::deadLetterConfig)).setter(PipeSourceKinesisStreamParameters.setter(Builder::deadLetterConfig)).constructor(DeadLetterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()}).build();
    private static final SdkField<String> ON_PARTIAL_BATCH_ITEM_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OnPartialBatchItemFailure").getter(PipeSourceKinesisStreamParameters.getter(PipeSourceKinesisStreamParameters::onPartialBatchItemFailureAsString)).setter(PipeSourceKinesisStreamParameters.setter(Builder::onPartialBatchItemFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnPartialBatchItemFailure").build()}).build();
    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumBatchingWindowInSeconds").getter(PipeSourceKinesisStreamParameters.getter(PipeSourceKinesisStreamParameters::maximumBatchingWindowInSeconds)).setter(PipeSourceKinesisStreamParameters.setter(Builder::maximumBatchingWindowInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds").build()}).build();
    private static final SdkField<Integer> MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumRecordAgeInSeconds").getter(PipeSourceKinesisStreamParameters.getter(PipeSourceKinesisStreamParameters::maximumRecordAgeInSeconds)).setter(PipeSourceKinesisStreamParameters.setter(Builder::maximumRecordAgeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRecordAgeInSeconds").build()}).build();
    private static final SdkField<Integer> MAXIMUM_RETRY_ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumRetryAttempts").getter(PipeSourceKinesisStreamParameters.getter(PipeSourceKinesisStreamParameters::maximumRetryAttempts)).setter(PipeSourceKinesisStreamParameters.setter(Builder::maximumRetryAttempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRetryAttempts").build()}).build();
    private static final SdkField<Integer> PARALLELIZATION_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParallelizationFactor").getter(PipeSourceKinesisStreamParameters.getter(PipeSourceKinesisStreamParameters::parallelizationFactor)).setter(PipeSourceKinesisStreamParameters.setter(Builder::parallelizationFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelizationFactor").build()}).build();
    private static final SdkField<String> STARTING_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartingPosition").getter(PipeSourceKinesisStreamParameters.getter(PipeSourceKinesisStreamParameters::startingPositionAsString)).setter(PipeSourceKinesisStreamParameters.setter(Builder::startingPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingPosition").build()}).build();
    private static final SdkField<Instant> STARTING_POSITION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartingPositionTimestamp").getter(PipeSourceKinesisStreamParameters.getter(PipeSourceKinesisStreamParameters::startingPositionTimestamp)).setter(PipeSourceKinesisStreamParameters.setter(Builder::startingPositionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingPositionTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_SIZE_FIELD, DEAD_LETTER_CONFIG_FIELD, ON_PARTIAL_BATCH_ITEM_FAILURE_FIELD, MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD, MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD, MAXIMUM_RETRY_ATTEMPTS_FIELD, PARALLELIZATION_FACTOR_FIELD, STARTING_POSITION_FIELD, STARTING_POSITION_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PipeSourceKinesisStreamParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer batchSize;
    private final DeadLetterConfig deadLetterConfig;
    private final String onPartialBatchItemFailure;
    private final Integer maximumBatchingWindowInSeconds;
    private final Integer maximumRecordAgeInSeconds;
    private final Integer maximumRetryAttempts;
    private final Integer parallelizationFactor;
    private final String startingPosition;
    private final Instant startingPositionTimestamp;

    private PipeSourceKinesisStreamParameters(BuilderImpl builder) {
        this.batchSize = builder.batchSize;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.onPartialBatchItemFailure = builder.onPartialBatchItemFailure;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
        this.maximumRecordAgeInSeconds = builder.maximumRecordAgeInSeconds;
        this.maximumRetryAttempts = builder.maximumRetryAttempts;
        this.parallelizationFactor = builder.parallelizationFactor;
        this.startingPosition = builder.startingPosition;
        this.startingPositionTimestamp = builder.startingPositionTimestamp;
    }

    public final Integer batchSize() {
        return this.batchSize;
    }

    public final DeadLetterConfig deadLetterConfig() {
        return this.deadLetterConfig;
    }

    public final OnPartialBatchItemFailureStreams onPartialBatchItemFailure() {
        return OnPartialBatchItemFailureStreams.fromValue(this.onPartialBatchItemFailure);
    }

    public final String onPartialBatchItemFailureAsString() {
        return this.onPartialBatchItemFailure;
    }

    public final Integer maximumBatchingWindowInSeconds() {
        return this.maximumBatchingWindowInSeconds;
    }

    public final Integer maximumRecordAgeInSeconds() {
        return this.maximumRecordAgeInSeconds;
    }

    public final Integer maximumRetryAttempts() {
        return this.maximumRetryAttempts;
    }

    public final Integer parallelizationFactor() {
        return this.parallelizationFactor;
    }

    public final KinesisStreamStartPosition startingPosition() {
        return KinesisStreamStartPosition.fromValue(this.startingPosition);
    }

    public final String startingPositionAsString() {
        return this.startingPosition;
    }

    public final Instant startingPositionTimestamp() {
        return this.startingPositionTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.onPartialBatchItemFailureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBatchingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumRecordAgeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumRetryAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelizationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingPositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingPositionTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeSourceKinesisStreamParameters)) {
            return false;
        }
        PipeSourceKinesisStreamParameters other = (PipeSourceKinesisStreamParameters)obj;
        return Objects.equals(this.batchSize(), other.batchSize()) && Objects.equals(this.deadLetterConfig(), other.deadLetterConfig()) && Objects.equals(this.onPartialBatchItemFailureAsString(), other.onPartialBatchItemFailureAsString()) && Objects.equals(this.maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds()) && Objects.equals(this.maximumRecordAgeInSeconds(), other.maximumRecordAgeInSeconds()) && Objects.equals(this.maximumRetryAttempts(), other.maximumRetryAttempts()) && Objects.equals(this.parallelizationFactor(), other.parallelizationFactor()) && Objects.equals(this.startingPositionAsString(), other.startingPositionAsString()) && Objects.equals(this.startingPositionTimestamp(), other.startingPositionTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"PipeSourceKinesisStreamParameters").add("BatchSize", (Object)this.batchSize()).add("DeadLetterConfig", (Object)this.deadLetterConfig()).add("OnPartialBatchItemFailure", (Object)this.onPartialBatchItemFailureAsString()).add("MaximumBatchingWindowInSeconds", (Object)this.maximumBatchingWindowInSeconds()).add("MaximumRecordAgeInSeconds", (Object)this.maximumRecordAgeInSeconds()).add("MaximumRetryAttempts", (Object)this.maximumRetryAttempts()).add("ParallelizationFactor", (Object)this.parallelizationFactor()).add("StartingPosition", (Object)this.startingPositionAsString()).add("StartingPositionTimestamp", (Object)this.startingPositionTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BatchSize": {
                return Optional.ofNullable(clazz.cast(this.batchSize()));
            }
            case "DeadLetterConfig": {
                return Optional.ofNullable(clazz.cast(this.deadLetterConfig()));
            }
            case "OnPartialBatchItemFailure": {
                return Optional.ofNullable(clazz.cast(this.onPartialBatchItemFailureAsString()));
            }
            case "MaximumBatchingWindowInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumBatchingWindowInSeconds()));
            }
            case "MaximumRecordAgeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumRecordAgeInSeconds()));
            }
            case "MaximumRetryAttempts": {
                return Optional.ofNullable(clazz.cast(this.maximumRetryAttempts()));
            }
            case "ParallelizationFactor": {
                return Optional.ofNullable(clazz.cast(this.parallelizationFactor()));
            }
            case "StartingPosition": {
                return Optional.ofNullable(clazz.cast(this.startingPositionAsString()));
            }
            case "StartingPositionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startingPositionTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BatchSize", BATCH_SIZE_FIELD);
        map.put("DeadLetterConfig", DEAD_LETTER_CONFIG_FIELD);
        map.put("OnPartialBatchItemFailure", ON_PARTIAL_BATCH_ITEM_FAILURE_FIELD);
        map.put("MaximumBatchingWindowInSeconds", MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD);
        map.put("MaximumRecordAgeInSeconds", MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD);
        map.put("MaximumRetryAttempts", MAXIMUM_RETRY_ATTEMPTS_FIELD);
        map.put("ParallelizationFactor", PARALLELIZATION_FACTOR_FIELD);
        map.put("StartingPosition", STARTING_POSITION_FIELD);
        map.put("StartingPositionTimestamp", STARTING_POSITION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipeSourceKinesisStreamParameters, T> g) {
        return obj -> g.apply((PipeSourceKinesisStreamParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer batchSize;
        private DeadLetterConfig deadLetterConfig;
        private String onPartialBatchItemFailure;
        private Integer maximumBatchingWindowInSeconds;
        private Integer maximumRecordAgeInSeconds;
        private Integer maximumRetryAttempts;
        private Integer parallelizationFactor;
        private String startingPosition;
        private Instant startingPositionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(PipeSourceKinesisStreamParameters model) {
            this.batchSize(model.batchSize);
            this.deadLetterConfig(model.deadLetterConfig);
            this.onPartialBatchItemFailure(model.onPartialBatchItemFailure);
            this.maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
            this.maximumRecordAgeInSeconds(model.maximumRecordAgeInSeconds);
            this.maximumRetryAttempts(model.maximumRetryAttempts);
            this.parallelizationFactor(model.parallelizationFactor);
            this.startingPosition(model.startingPosition);
            this.startingPositionTimestamp(model.startingPositionTimestamp);
        }

        public final Integer getBatchSize() {
            return this.batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return this.deadLetterConfig != null ? this.deadLetterConfig.toBuilder() : null;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final String getOnPartialBatchItemFailure() {
            return this.onPartialBatchItemFailure;
        }

        public final void setOnPartialBatchItemFailure(String onPartialBatchItemFailure) {
            this.onPartialBatchItemFailure = onPartialBatchItemFailure;
        }

        @Override
        public final Builder onPartialBatchItemFailure(String onPartialBatchItemFailure) {
            this.onPartialBatchItemFailure = onPartialBatchItemFailure;
            return this;
        }

        @Override
        public final Builder onPartialBatchItemFailure(OnPartialBatchItemFailureStreams onPartialBatchItemFailure) {
            this.onPartialBatchItemFailure(onPartialBatchItemFailure == null ? null : onPartialBatchItemFailure.toString());
            return this;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return this.maximumBatchingWindowInSeconds;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public final Integer getMaximumRecordAgeInSeconds() {
            return this.maximumRecordAgeInSeconds;
        }

        public final void setMaximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
        }

        @Override
        public final Builder maximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
            return this;
        }

        public final Integer getMaximumRetryAttempts() {
            return this.maximumRetryAttempts;
        }

        public final void setMaximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
        }

        @Override
        public final Builder maximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        public final Integer getParallelizationFactor() {
            return this.parallelizationFactor;
        }

        public final void setParallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
        }

        @Override
        public final Builder parallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        public final String getStartingPosition() {
            return this.startingPosition;
        }

        public final void setStartingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
        }

        @Override
        public final Builder startingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        @Override
        public final Builder startingPosition(KinesisStreamStartPosition startingPosition) {
            this.startingPosition(startingPosition == null ? null : startingPosition.toString());
            return this;
        }

        public final Instant getStartingPositionTimestamp() {
            return this.startingPositionTimestamp;
        }

        public final void setStartingPositionTimestamp(Instant startingPositionTimestamp) {
            this.startingPositionTimestamp = startingPositionTimestamp;
        }

        @Override
        public final Builder startingPositionTimestamp(Instant startingPositionTimestamp) {
            this.startingPositionTimestamp = startingPositionTimestamp;
            return this;
        }

        public PipeSourceKinesisStreamParameters build() {
            return new PipeSourceKinesisStreamParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipeSourceKinesisStreamParameters> {
        public Builder batchSize(Integer var1);

        public Builder deadLetterConfig(DeadLetterConfig var1);

        default public Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return this.deadLetterConfig((DeadLetterConfig)((DeadLetterConfig.Builder)DeadLetterConfig.builder().applyMutation(deadLetterConfig)).build());
        }

        public Builder onPartialBatchItemFailure(String var1);

        public Builder onPartialBatchItemFailure(OnPartialBatchItemFailureStreams var1);

        public Builder maximumBatchingWindowInSeconds(Integer var1);

        public Builder maximumRecordAgeInSeconds(Integer var1);

        public Builder maximumRetryAttempts(Integer var1);

        public Builder parallelizationFactor(Integer var1);

        public Builder startingPosition(String var1);

        public Builder startingPosition(KinesisStreamStartPosition var1);

        public Builder startingPositionTimestamp(Instant var1);
    }
}

