/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MSKAccessCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MSKAccessCredentials> {
    private static final SdkField<String> SASL_SCRAM512_AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SaslScram512Auth").getter(MSKAccessCredentials.getter(MSKAccessCredentials::saslScram512Auth)).setter(MSKAccessCredentials.setter(Builder::saslScram512Auth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SaslScram512Auth").build()}).build();
    private static final SdkField<String> CLIENT_CERTIFICATE_TLS_AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientCertificateTlsAuth").getter(MSKAccessCredentials.getter(MSKAccessCredentials::clientCertificateTlsAuth)).setter(MSKAccessCredentials.setter(Builder::clientCertificateTlsAuth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCertificateTlsAuth").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SASL_SCRAM512_AUTH_FIELD, CLIENT_CERTIFICATE_TLS_AUTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MSKAccessCredentials.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String saslScram512Auth;
    private final String clientCertificateTlsAuth;
    private final Type type;

    private MSKAccessCredentials(BuilderImpl builder) {
        this.saslScram512Auth = builder.saslScram512Auth;
        this.clientCertificateTlsAuth = builder.clientCertificateTlsAuth;
        this.type = builder.type;
    }

    public final String saslScram512Auth() {
        return this.saslScram512Auth;
    }

    public final String clientCertificateTlsAuth() {
        return this.clientCertificateTlsAuth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.saslScram512Auth());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCertificateTlsAuth());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MSKAccessCredentials)) {
            return false;
        }
        MSKAccessCredentials other = (MSKAccessCredentials)obj;
        return Objects.equals(this.saslScram512Auth(), other.saslScram512Auth()) && Objects.equals(this.clientCertificateTlsAuth(), other.clientCertificateTlsAuth());
    }

    public final String toString() {
        return ToString.builder((String)"MSKAccessCredentials").add("SaslScram512Auth", (Object)this.saslScram512Auth()).add("ClientCertificateTlsAuth", (Object)this.clientCertificateTlsAuth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SaslScram512Auth": {
                return Optional.ofNullable(clazz.cast(this.saslScram512Auth()));
            }
            case "ClientCertificateTlsAuth": {
                return Optional.ofNullable(clazz.cast(this.clientCertificateTlsAuth()));
            }
        }
        return Optional.empty();
    }

    public static MSKAccessCredentials fromSaslScram512Auth(String saslScram512Auth) {
        return (MSKAccessCredentials)MSKAccessCredentials.builder().saslScram512Auth(saslScram512Auth).build();
    }

    public static MSKAccessCredentials fromClientCertificateTlsAuth(String clientCertificateTlsAuth) {
        return (MSKAccessCredentials)MSKAccessCredentials.builder().clientCertificateTlsAuth(clientCertificateTlsAuth).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SaslScram512Auth", SASL_SCRAM512_AUTH_FIELD);
        map.put("ClientCertificateTlsAuth", CLIENT_CERTIFICATE_TLS_AUTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MSKAccessCredentials, T> g) {
        return obj -> g.apply((MSKAccessCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SASL_SCRAM512_AUTH,
        CLIENT_CERTIFICATE_TLS_AUTH,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String saslScram512Auth;
        private String clientCertificateTlsAuth;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MSKAccessCredentials model) {
            this.saslScram512Auth(model.saslScram512Auth);
            this.clientCertificateTlsAuth(model.clientCertificateTlsAuth);
        }

        public final String getSaslScram512Auth() {
            return this.saslScram512Auth;
        }

        public final void setSaslScram512Auth(String saslScram512Auth) {
            String oldValue = this.saslScram512Auth;
            this.saslScram512Auth = saslScram512Auth;
            this.handleUnionValueChange(Type.SASL_SCRAM512_AUTH, oldValue, this.saslScram512Auth);
        }

        @Override
        public final Builder saslScram512Auth(String saslScram512Auth) {
            String oldValue = this.saslScram512Auth;
            this.saslScram512Auth = saslScram512Auth;
            this.handleUnionValueChange(Type.SASL_SCRAM512_AUTH, oldValue, this.saslScram512Auth);
            return this;
        }

        public final String getClientCertificateTlsAuth() {
            return this.clientCertificateTlsAuth;
        }

        public final void setClientCertificateTlsAuth(String clientCertificateTlsAuth) {
            String oldValue = this.clientCertificateTlsAuth;
            this.clientCertificateTlsAuth = clientCertificateTlsAuth;
            this.handleUnionValueChange(Type.CLIENT_CERTIFICATE_TLS_AUTH, oldValue, this.clientCertificateTlsAuth);
        }

        @Override
        public final Builder clientCertificateTlsAuth(String clientCertificateTlsAuth) {
            String oldValue = this.clientCertificateTlsAuth;
            this.clientCertificateTlsAuth = clientCertificateTlsAuth;
            this.handleUnionValueChange(Type.CLIENT_CERTIFICATE_TLS_AUTH, oldValue, this.clientCertificateTlsAuth);
            return this;
        }

        public MSKAccessCredentials build() {
            return new MSKAccessCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MSKAccessCredentials> {
        public Builder saslScram512Auth(String var1);

        public Builder clientCertificateTlsAuth(String var1);
    }
}

