/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pipes.model.EventBridgeEventResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipeTargetEventBridgeEventBusParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipeTargetEventBridgeEventBusParameters> {
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointId").getter(PipeTargetEventBridgeEventBusParameters.getter(PipeTargetEventBridgeEventBusParameters::endpointId)).setter(PipeTargetEventBridgeEventBusParameters.setter(Builder::endpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()}).build();
    private static final SdkField<String> DETAIL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetailType").getter(PipeTargetEventBridgeEventBusParameters.getter(PipeTargetEventBridgeEventBusParameters::detailType)).setter(PipeTargetEventBridgeEventBusParameters.setter(Builder::detailType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailType").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(PipeTargetEventBridgeEventBusParameters.getter(PipeTargetEventBridgeEventBusParameters::source)).setter(PipeTargetEventBridgeEventBusParameters.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(PipeTargetEventBridgeEventBusParameters.getter(PipeTargetEventBridgeEventBusParameters::resources)).setter(PipeTargetEventBridgeEventBusParameters.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Time").getter(PipeTargetEventBridgeEventBusParameters.getter(PipeTargetEventBridgeEventBusParameters::time)).setter(PipeTargetEventBridgeEventBusParameters.setter(Builder::time)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ID_FIELD, DETAIL_TYPE_FIELD, SOURCE_FIELD, RESOURCES_FIELD, TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EndpointId", ENDPOINT_ID_FIELD);
            this.put("DetailType", DETAIL_TYPE_FIELD);
            this.put("Source", SOURCE_FIELD);
            this.put("Resources", RESOURCES_FIELD);
            this.put("Time", TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String endpointId;
    private final String detailType;
    private final String source;
    private final List<String> resources;
    private final String time;

    private PipeTargetEventBridgeEventBusParameters(BuilderImpl builder) {
        this.endpointId = builder.endpointId;
        this.detailType = builder.detailType;
        this.source = builder.source;
        this.resources = builder.resources;
        this.time = builder.time;
    }

    public final String endpointId() {
        return this.endpointId;
    }

    public final String detailType() {
        return this.detailType;
    }

    public final String source() {
        return this.source;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<String> resources() {
        return this.resources;
    }

    public final String time() {
        return this.time;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detailType());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.time());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeTargetEventBridgeEventBusParameters)) {
            return false;
        }
        PipeTargetEventBridgeEventBusParameters other = (PipeTargetEventBridgeEventBusParameters)obj;
        return Objects.equals(this.endpointId(), other.endpointId()) && Objects.equals(this.detailType(), other.detailType()) && Objects.equals(this.source(), other.source()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.time(), other.time());
    }

    public final String toString() {
        return ToString.builder((String)"PipeTargetEventBridgeEventBusParameters").add("EndpointId", (Object)(this.endpointId() == null ? null : "*** Sensitive Data Redacted ***")).add("DetailType", (Object)(this.detailType() == null ? null : "*** Sensitive Data Redacted ***")).add("Source", (Object)(this.source() == null ? null : "*** Sensitive Data Redacted ***")).add("Resources", this.hasResources() ? this.resources() : null).add("Time", (Object)this.time()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointId": {
                return Optional.ofNullable(clazz.cast(this.endpointId()));
            }
            case "DetailType": {
                return Optional.ofNullable(clazz.cast(this.detailType()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "Time": {
                return Optional.ofNullable(clazz.cast(this.time()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PipeTargetEventBridgeEventBusParameters, T> g) {
        return obj -> g.apply((PipeTargetEventBridgeEventBusParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointId;
        private String detailType;
        private String source;
        private List<String> resources = DefaultSdkAutoConstructList.getInstance();
        private String time;

        private BuilderImpl() {
        }

        private BuilderImpl(PipeTargetEventBridgeEventBusParameters model) {
            this.endpointId(model.endpointId);
            this.detailType(model.detailType);
            this.source(model.source);
            this.resources(model.resources);
            this.time(model.time);
        }

        public final String getEndpointId() {
            return this.endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final String getDetailType() {
            return this.detailType;
        }

        public final void setDetailType(String detailType) {
            this.detailType = detailType;
        }

        @Override
        public final Builder detailType(String detailType) {
            this.detailType = detailType;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final Collection<String> getResources() {
            if (this.resources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resources;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = EventBridgeEventResourceListCopier.copy(resources);
        }

        @Override
        public final Builder resources(Collection<String> resources) {
            this.resources = EventBridgeEventResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(String ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        public final String getTime() {
            return this.time;
        }

        public final void setTime(String time) {
            this.time = time;
        }

        @Override
        public final Builder time(String time) {
            this.time = time;
            return this;
        }

        public PipeTargetEventBridgeEventBusParameters build() {
            return new PipeTargetEventBridgeEventBusParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipeTargetEventBridgeEventBusParameters> {
        public Builder endpointId(String var1);

        public Builder detailType(String var1);

        public Builder source(String var1);

        public Builder resources(Collection<String> var1);

        public Builder resources(String ... var1);

        public Builder time(String var1);
    }
}

