/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pipes.model.PipeState;
import software.amazon.awssdk.services.pipes.model.PipesResponse;
import software.amazon.awssdk.services.pipes.model.RequestedPipeState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePipeResponse
extends PipesResponse
implements ToCopyableBuilder<Builder, UpdatePipeResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdatePipeResponse.getter(UpdatePipeResponse::arn)).setter(UpdatePipeResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdatePipeResponse.getter(UpdatePipeResponse::name)).setter(UpdatePipeResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DesiredState").getter(UpdatePipeResponse.getter(UpdatePipeResponse::desiredStateAsString)).setter(UpdatePipeResponse.setter(Builder::desiredState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredState").build()}).build();
    private static final SdkField<String> CURRENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentState").getter(UpdatePipeResponse.getter(UpdatePipeResponse::currentStateAsString)).setter(UpdatePipeResponse.setter(Builder::currentState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentState").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(UpdatePipeResponse.getter(UpdatePipeResponse::creationTime)).setter(UpdatePipeResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(UpdatePipeResponse.getter(UpdatePipeResponse::lastModifiedTime)).setter(UpdatePipeResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DESIRED_STATE_FIELD, CURRENT_STATE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private final String arn;
    private final String name;
    private final String desiredState;
    private final String currentState;
    private final Instant creationTime;
    private final Instant lastModifiedTime;

    private UpdatePipeResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.desiredState = builder.desiredState;
        this.currentState = builder.currentState;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final RequestedPipeState desiredState() {
        return RequestedPipeState.fromValue(this.desiredState);
    }

    public final String desiredStateAsString() {
        return this.desiredState;
    }

    public final PipeState currentState() {
        return PipeState.fromValue(this.currentState);
    }

    public final String currentStateAsString() {
        return this.currentState;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipeResponse)) {
            return false;
        }
        UpdatePipeResponse other = (UpdatePipeResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.desiredStateAsString(), other.desiredStateAsString()) && Objects.equals(this.currentStateAsString(), other.currentStateAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePipeResponse").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("DesiredState", (Object)this.desiredStateAsString()).add("CurrentState", (Object)this.currentStateAsString()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DesiredState": {
                return Optional.ofNullable(clazz.cast(this.desiredStateAsString()));
            }
            case "CurrentState": {
                return Optional.ofNullable(clazz.cast(this.currentStateAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipeResponse, T> g) {
        return obj -> g.apply((UpdatePipeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PipesResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String desiredState;
        private String currentState;
        private Instant creationTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipeResponse model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.desiredState(model.desiredState);
            this.currentState(model.currentState);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDesiredState() {
            return this.desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(RequestedPipeState desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final String getCurrentState() {
            return this.currentState;
        }

        public final void setCurrentState(String currentState) {
            this.currentState = currentState;
        }

        @Override
        public final Builder currentState(String currentState) {
            this.currentState = currentState;
            return this;
        }

        @Override
        public final Builder currentState(PipeState currentState) {
            this.currentState(currentState == null ? null : currentState.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public UpdatePipeResponse build() {
            return new UpdatePipeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PipesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePipeResponse> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder desiredState(String var1);

        public Builder desiredState(RequestedPipeState var1);

        public Builder currentState(String var1);

        public Builder currentState(PipeState var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

