/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pipes.model.PipeState;
import software.amazon.awssdk.services.pipes.model.PipesRequest;
import software.amazon.awssdk.services.pipes.model.RequestedPipeState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPipesRequest
extends PipesRequest
implements ToCopyableBuilder<Builder, ListPipesRequest> {
    private static final SdkField<String> NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NamePrefix").getter(ListPipesRequest.getter(ListPipesRequest::namePrefix)).setter(ListPipesRequest.setter(Builder::namePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NamePrefix").build()}).build();
    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DesiredState").getter(ListPipesRequest.getter(ListPipesRequest::desiredStateAsString)).setter(ListPipesRequest.setter(Builder::desiredState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DesiredState").build()}).build();
    private static final SdkField<String> CURRENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentState").getter(ListPipesRequest.getter(ListPipesRequest::currentStateAsString)).setter(ListPipesRequest.setter(Builder::currentState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("CurrentState").build()}).build();
    private static final SdkField<String> SOURCE_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourcePrefix").getter(ListPipesRequest.getter(ListPipesRequest::sourcePrefix)).setter(ListPipesRequest.setter(Builder::sourcePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("SourcePrefix").build()}).build();
    private static final SdkField<String> TARGET_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetPrefix").getter(ListPipesRequest.getter(ListPipesRequest::targetPrefix)).setter(ListPipesRequest.setter(Builder::targetPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("TargetPrefix").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPipesRequest.getter(ListPipesRequest::nextToken)).setter(ListPipesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(ListPipesRequest.getter(ListPipesRequest::limit)).setter(ListPipesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Limit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_PREFIX_FIELD, DESIRED_STATE_FIELD, CURRENT_STATE_FIELD, SOURCE_PREFIX_FIELD, TARGET_PREFIX_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NamePrefix", NAME_PREFIX_FIELD);
            this.put("DesiredState", DESIRED_STATE_FIELD);
            this.put("CurrentState", CURRENT_STATE_FIELD);
            this.put("SourcePrefix", SOURCE_PREFIX_FIELD);
            this.put("TargetPrefix", TARGET_PREFIX_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("Limit", LIMIT_FIELD);
        }
    });
    private final String namePrefix;
    private final String desiredState;
    private final String currentState;
    private final String sourcePrefix;
    private final String targetPrefix;
    private final String nextToken;
    private final Integer limit;

    private ListPipesRequest(BuilderImpl builder) {
        super(builder);
        this.namePrefix = builder.namePrefix;
        this.desiredState = builder.desiredState;
        this.currentState = builder.currentState;
        this.sourcePrefix = builder.sourcePrefix;
        this.targetPrefix = builder.targetPrefix;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    public final String namePrefix() {
        return this.namePrefix;
    }

    public final RequestedPipeState desiredState() {
        return RequestedPipeState.fromValue(this.desiredState);
    }

    public final String desiredStateAsString() {
        return this.desiredState;
    }

    public final PipeState currentState() {
        return PipeState.fromValue(this.currentState);
    }

    public final String currentStateAsString() {
        return this.currentState;
    }

    public final String sourcePrefix() {
        return this.sourcePrefix;
    }

    public final String targetPrefix() {
        return this.targetPrefix;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.namePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipesRequest)) {
            return false;
        }
        ListPipesRequest other = (ListPipesRequest)((Object)obj);
        return Objects.equals(this.namePrefix(), other.namePrefix()) && Objects.equals(this.desiredStateAsString(), other.desiredStateAsString()) && Objects.equals(this.currentStateAsString(), other.currentStateAsString()) && Objects.equals(this.sourcePrefix(), other.sourcePrefix()) && Objects.equals(this.targetPrefix(), other.targetPrefix()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.limit(), other.limit());
    }

    public final String toString() {
        return ToString.builder((String)"ListPipesRequest").add("NamePrefix", (Object)this.namePrefix()).add("DesiredState", (Object)this.desiredStateAsString()).add("CurrentState", (Object)this.currentStateAsString()).add("SourcePrefix", (Object)this.sourcePrefix()).add("TargetPrefix", (Object)this.targetPrefix()).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).add("Limit", (Object)this.limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamePrefix": {
                return Optional.ofNullable(clazz.cast(this.namePrefix()));
            }
            case "DesiredState": {
                return Optional.ofNullable(clazz.cast(this.desiredStateAsString()));
            }
            case "CurrentState": {
                return Optional.ofNullable(clazz.cast(this.currentStateAsString()));
            }
            case "SourcePrefix": {
                return Optional.ofNullable(clazz.cast(this.sourcePrefix()));
            }
            case "TargetPrefix": {
                return Optional.ofNullable(clazz.cast(this.targetPrefix()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPipesRequest, T> g) {
        return obj -> g.apply((ListPipesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PipesRequest.BuilderImpl
    implements Builder {
        private String namePrefix;
        private String desiredState;
        private String currentState;
        private String sourcePrefix;
        private String targetPrefix;
        private String nextToken;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipesRequest model) {
            super(model);
            this.namePrefix(model.namePrefix);
            this.desiredState(model.desiredState);
            this.currentState(model.currentState);
            this.sourcePrefix(model.sourcePrefix);
            this.targetPrefix(model.targetPrefix);
            this.nextToken(model.nextToken);
            this.limit(model.limit);
        }

        public final String getNamePrefix() {
            return this.namePrefix;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final String getDesiredState() {
            return this.desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(RequestedPipeState desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final String getCurrentState() {
            return this.currentState;
        }

        public final void setCurrentState(String currentState) {
            this.currentState = currentState;
        }

        @Override
        public final Builder currentState(String currentState) {
            this.currentState = currentState;
            return this;
        }

        @Override
        public final Builder currentState(PipeState currentState) {
            this.currentState(currentState == null ? null : currentState.toString());
            return this;
        }

        public final String getSourcePrefix() {
            return this.sourcePrefix;
        }

        public final void setSourcePrefix(String sourcePrefix) {
            this.sourcePrefix = sourcePrefix;
        }

        @Override
        public final Builder sourcePrefix(String sourcePrefix) {
            this.sourcePrefix = sourcePrefix;
            return this;
        }

        public final String getTargetPrefix() {
            return this.targetPrefix;
        }

        public final void setTargetPrefix(String targetPrefix) {
            this.targetPrefix = targetPrefix;
        }

        @Override
        public final Builder targetPrefix(String targetPrefix) {
            this.targetPrefix = targetPrefix;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPipesRequest build() {
            return new ListPipesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PipesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPipesRequest> {
        public Builder namePrefix(String var1);

        public Builder desiredState(String var1);

        public Builder desiredState(RequestedPipeState var1);

        public Builder currentState(String var1);

        public Builder currentState(PipeState var1);

        public Builder sourcePrefix(String var1);

        public Builder targetPrefix(String var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

