/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pipes.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.services.pipes.model.SubnetIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SelfManagedKafkaAccessConfigurationVpc
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SelfManagedKafkaAccessConfigurationVpc> {
    private static final SdkField<List<String>> SECURITY_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroup").getter(SelfManagedKafkaAccessConfigurationVpc.getter(SelfManagedKafkaAccessConfigurationVpc::securityGroup)).setter(SelfManagedKafkaAccessConfigurationVpc.setter(Builder::securityGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroup").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subnets").getter(SelfManagedKafkaAccessConfigurationVpc.getter(SelfManagedKafkaAccessConfigurationVpc::subnets)).setter(SelfManagedKafkaAccessConfigurationVpc.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_GROUP_FIELD, SUBNETS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> securityGroup;
    private final List<String> subnets;

    private SelfManagedKafkaAccessConfigurationVpc(BuilderImpl builder) {
        this.securityGroup = builder.securityGroup;
        this.subnets = builder.subnets;
    }

    public final boolean hasSecurityGroup() {
        return this.securityGroup != null && !(this.securityGroup instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroup() {
        return this.securityGroup;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<String> subnets() {
        return this.subnets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroup() ? this.securityGroup() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfManagedKafkaAccessConfigurationVpc)) {
            return false;
        }
        SelfManagedKafkaAccessConfigurationVpc other = (SelfManagedKafkaAccessConfigurationVpc)obj;
        return this.hasSecurityGroup() == other.hasSecurityGroup() && Objects.equals(this.securityGroup(), other.securityGroup()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets());
    }

    public final String toString() {
        return ToString.builder((String)"SelfManagedKafkaAccessConfigurationVpc").add("SecurityGroup", (Object)(this.securityGroup() == null ? null : "*** Sensitive Data Redacted ***")).add("Subnets", (Object)(this.subnets() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityGroup": {
                return Optional.ofNullable(clazz.cast(this.securityGroup()));
            }
            case "Subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SelfManagedKafkaAccessConfigurationVpc, T> g) {
        return obj -> g.apply((SelfManagedKafkaAccessConfigurationVpc)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> securityGroup = DefaultSdkAutoConstructList.getInstance();
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SelfManagedKafkaAccessConfigurationVpc model) {
            this.securityGroup(model.securityGroup);
            this.subnets(model.subnets);
        }

        public final Collection<String> getSecurityGroup() {
            if (this.securityGroup instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroup;
        }

        public final void setSecurityGroup(Collection<String> securityGroup) {
            this.securityGroup = SecurityGroupIdsCopier.copy(securityGroup);
        }

        @Override
        public final Builder securityGroup(Collection<String> securityGroup) {
            this.securityGroup = SecurityGroupIdsCopier.copy(securityGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroup(String ... securityGroup) {
            this.securityGroup(Arrays.asList(securityGroup));
            return this;
        }

        public final Collection<String> getSubnets() {
            if (this.subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetIdsCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetIdsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public SelfManagedKafkaAccessConfigurationVpc build() {
            return new SelfManagedKafkaAccessConfigurationVpc(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SelfManagedKafkaAccessConfigurationVpc> {
        public Builder securityGroup(Collection<String> var1);

        public Builder securityGroup(String ... var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);
    }
}

