/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutFilter;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutFilterListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutNumberListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOptedOutNumbersRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, DescribeOptedOutNumbersRequest> {
    private static final SdkField<String> OPT_OUT_LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptOutListName").getter(DescribeOptedOutNumbersRequest.getter(DescribeOptedOutNumbersRequest::optOutListName)).setter(DescribeOptedOutNumbersRequest.setter(Builder::optOutListName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListName").build()}).build();
    private static final SdkField<List<String>> OPTED_OUT_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OptedOutNumbers").getter(DescribeOptedOutNumbersRequest.getter(DescribeOptedOutNumbersRequest::optedOutNumbers)).setter(DescribeOptedOutNumbersRequest.setter(Builder::optedOutNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptedOutNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OptedOutFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeOptedOutNumbersRequest.getter(DescribeOptedOutNumbersRequest::filters)).setter(DescribeOptedOutNumbersRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OptedOutFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeOptedOutNumbersRequest.getter(DescribeOptedOutNumbersRequest::nextToken)).setter(DescribeOptedOutNumbersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeOptedOutNumbersRequest.getter(DescribeOptedOutNumbersRequest::maxResults)).setter(DescribeOptedOutNumbersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPT_OUT_LIST_NAME_FIELD, OPTED_OUT_NUMBERS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeOptedOutNumbersRequest.memberNameToFieldInitializer();
    private final String optOutListName;
    private final List<String> optedOutNumbers;
    private final List<OptedOutFilter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeOptedOutNumbersRequest(BuilderImpl builder) {
        super(builder);
        this.optOutListName = builder.optOutListName;
        this.optedOutNumbers = builder.optedOutNumbers;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String optOutListName() {
        return this.optOutListName;
    }

    public final boolean hasOptedOutNumbers() {
        return this.optedOutNumbers != null && !(this.optedOutNumbers instanceof SdkAutoConstructList);
    }

    public final List<String> optedOutNumbers() {
        return this.optedOutNumbers;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<OptedOutFilter> filters() {
        return this.filters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.optOutListName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptedOutNumbers() ? this.optedOutNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOptedOutNumbersRequest)) {
            return false;
        }
        DescribeOptedOutNumbersRequest other = (DescribeOptedOutNumbersRequest)((Object)obj);
        return Objects.equals(this.optOutListName(), other.optOutListName()) && this.hasOptedOutNumbers() == other.hasOptedOutNumbers() && Objects.equals(this.optedOutNumbers(), other.optedOutNumbers()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOptedOutNumbersRequest").add("OptOutListName", (Object)this.optOutListName()).add("OptedOutNumbers", this.hasOptedOutNumbers() ? this.optedOutNumbers() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptOutListName": {
                return Optional.ofNullable(clazz.cast(this.optOutListName()));
            }
            case "OptedOutNumbers": {
                return Optional.ofNullable(clazz.cast(this.optedOutNumbers()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OptOutListName", OPT_OUT_LIST_NAME_FIELD);
        map.put("OptedOutNumbers", OPTED_OUT_NUMBERS_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeOptedOutNumbersRequest, T> g) {
        return obj -> g.apply((DescribeOptedOutNumbersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private String optOutListName;
        private List<String> optedOutNumbers = DefaultSdkAutoConstructList.getInstance();
        private List<OptedOutFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOptedOutNumbersRequest model) {
            super(model);
            this.optOutListName(model.optOutListName);
            this.optedOutNumbers(model.optedOutNumbers);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getOptOutListName() {
            return this.optOutListName;
        }

        public final void setOptOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
        }

        @Override
        public final Builder optOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        public final Collection<String> getOptedOutNumbers() {
            if (this.optedOutNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.optedOutNumbers;
        }

        public final void setOptedOutNumbers(Collection<String> optedOutNumbers) {
            this.optedOutNumbers = OptedOutNumberListCopier.copy(optedOutNumbers);
        }

        @Override
        public final Builder optedOutNumbers(Collection<String> optedOutNumbers) {
            this.optedOutNumbers = OptedOutNumberListCopier.copy(optedOutNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optedOutNumbers(String ... optedOutNumbers) {
            this.optedOutNumbers(Arrays.asList(optedOutNumbers));
            return this;
        }

        public final List<OptedOutFilter.Builder> getFilters() {
            List<OptedOutFilter.Builder> result = OptedOutFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<OptedOutFilter.BuilderImpl> filters) {
            this.filters = OptedOutFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<OptedOutFilter> filters) {
            this.filters = OptedOutFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(OptedOutFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<OptedOutFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (OptedOutFilter)((OptedOutFilter.Builder)OptedOutFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeOptedOutNumbersRequest build() {
            return new DescribeOptedOutNumbersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOptedOutNumbersRequest> {
        public Builder optOutListName(String var1);

        public Builder optedOutNumbers(Collection<String> var1);

        public Builder optedOutNumbers(String ... var1);

        public Builder filters(Collection<OptedOutFilter> var1);

        public Builder filters(OptedOutFilter ... var1);

        public Builder filters(Consumer<OptedOutFilter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

