/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationSectionDefinition;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationSectionDefinitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRegistrationSectionDefinitionsResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, DescribeRegistrationSectionDefinitionsResponse> {
    private static final SdkField<String> REGISTRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationType").getter(DescribeRegistrationSectionDefinitionsResponse.getter(DescribeRegistrationSectionDefinitionsResponse::registrationType)).setter(DescribeRegistrationSectionDefinitionsResponse.setter(Builder::registrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationType").build()}).build();
    private static final SdkField<List<RegistrationSectionDefinition>> REGISTRATION_SECTION_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegistrationSectionDefinitions").getter(DescribeRegistrationSectionDefinitionsResponse.getter(DescribeRegistrationSectionDefinitionsResponse::registrationSectionDefinitions)).setter(DescribeRegistrationSectionDefinitionsResponse.setter(Builder::registrationSectionDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationSectionDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegistrationSectionDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeRegistrationSectionDefinitionsResponse.getter(DescribeRegistrationSectionDefinitionsResponse::nextToken)).setter(DescribeRegistrationSectionDefinitionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_TYPE_FIELD, REGISTRATION_SECTION_DEFINITIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeRegistrationSectionDefinitionsResponse.memberNameToFieldInitializer();
    private final String registrationType;
    private final List<RegistrationSectionDefinition> registrationSectionDefinitions;
    private final String nextToken;

    private DescribeRegistrationSectionDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.registrationType = builder.registrationType;
        this.registrationSectionDefinitions = builder.registrationSectionDefinitions;
        this.nextToken = builder.nextToken;
    }

    public final String registrationType() {
        return this.registrationType;
    }

    public final boolean hasRegistrationSectionDefinitions() {
        return this.registrationSectionDefinitions != null && !(this.registrationSectionDefinitions instanceof SdkAutoConstructList);
    }

    public final List<RegistrationSectionDefinition> registrationSectionDefinitions() {
        return this.registrationSectionDefinitions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegistrationSectionDefinitions() ? this.registrationSectionDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistrationSectionDefinitionsResponse)) {
            return false;
        }
        DescribeRegistrationSectionDefinitionsResponse other = (DescribeRegistrationSectionDefinitionsResponse)((Object)obj);
        return Objects.equals(this.registrationType(), other.registrationType()) && this.hasRegistrationSectionDefinitions() == other.hasRegistrationSectionDefinitions() && Objects.equals(this.registrationSectionDefinitions(), other.registrationSectionDefinitions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRegistrationSectionDefinitionsResponse").add("RegistrationType", (Object)this.registrationType()).add("RegistrationSectionDefinitions", this.hasRegistrationSectionDefinitions() ? this.registrationSectionDefinitions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistrationType": {
                return Optional.ofNullable(clazz.cast(this.registrationType()));
            }
            case "RegistrationSectionDefinitions": {
                return Optional.ofNullable(clazz.cast(this.registrationSectionDefinitions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RegistrationType", REGISTRATION_TYPE_FIELD);
        map.put("RegistrationSectionDefinitions", REGISTRATION_SECTION_DEFINITIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegistrationSectionDefinitionsResponse, T> g) {
        return obj -> g.apply((DescribeRegistrationSectionDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private String registrationType;
        private List<RegistrationSectionDefinition> registrationSectionDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegistrationSectionDefinitionsResponse model) {
            super(model);
            this.registrationType(model.registrationType);
            this.registrationSectionDefinitions(model.registrationSectionDefinitions);
            this.nextToken(model.nextToken);
        }

        public final String getRegistrationType() {
            return this.registrationType;
        }

        public final void setRegistrationType(String registrationType) {
            this.registrationType = registrationType;
        }

        @Override
        public final Builder registrationType(String registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        public final List<RegistrationSectionDefinition.Builder> getRegistrationSectionDefinitions() {
            List<RegistrationSectionDefinition.Builder> result = RegistrationSectionDefinitionListCopier.copyToBuilder(this.registrationSectionDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistrationSectionDefinitions(Collection<RegistrationSectionDefinition.BuilderImpl> registrationSectionDefinitions) {
            this.registrationSectionDefinitions = RegistrationSectionDefinitionListCopier.copyFromBuilder(registrationSectionDefinitions);
        }

        @Override
        public final Builder registrationSectionDefinitions(Collection<RegistrationSectionDefinition> registrationSectionDefinitions) {
            this.registrationSectionDefinitions = RegistrationSectionDefinitionListCopier.copy(registrationSectionDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationSectionDefinitions(RegistrationSectionDefinition ... registrationSectionDefinitions) {
            this.registrationSectionDefinitions(Arrays.asList(registrationSectionDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationSectionDefinitions(Consumer<RegistrationSectionDefinition.Builder> ... registrationSectionDefinitions) {
            this.registrationSectionDefinitions(Stream.of(registrationSectionDefinitions).map(c -> (RegistrationSectionDefinition)((RegistrationSectionDefinition.Builder)RegistrationSectionDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRegistrationSectionDefinitionsResponse build() {
            return new DescribeRegistrationSectionDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRegistrationSectionDefinitionsResponse> {
        public Builder registrationType(String var1);

        public Builder registrationSectionDefinitions(Collection<RegistrationSectionDefinition> var1);

        public Builder registrationSectionDefinitions(RegistrationSectionDefinition ... var1);

        public Builder registrationSectionDefinitions(Consumer<RegistrationSectionDefinition.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

