/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.FieldRequirement;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.FieldType;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationFieldDisplayHints;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SelectValidation;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.TextValidation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegistrationFieldDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegistrationFieldDefinition> {
    private static final SdkField<String> SECTION_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SectionPath").getter(RegistrationFieldDefinition.getter(RegistrationFieldDefinition::sectionPath)).setter(RegistrationFieldDefinition.setter(Builder::sectionPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SectionPath").build()}).build();
    private static final SdkField<String> FIELD_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldPath").getter(RegistrationFieldDefinition.getter(RegistrationFieldDefinition::fieldPath)).setter(RegistrationFieldDefinition.setter(Builder::fieldPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldPath").build()}).build();
    private static final SdkField<String> FIELD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldType").getter(RegistrationFieldDefinition.getter(RegistrationFieldDefinition::fieldTypeAsString)).setter(RegistrationFieldDefinition.setter(Builder::fieldType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldType").build()}).build();
    private static final SdkField<String> FIELD_REQUIREMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldRequirement").getter(RegistrationFieldDefinition.getter(RegistrationFieldDefinition::fieldRequirementAsString)).setter(RegistrationFieldDefinition.setter(Builder::fieldRequirement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldRequirement").build()}).build();
    private static final SdkField<SelectValidation> SELECT_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelectValidation").getter(RegistrationFieldDefinition.getter(RegistrationFieldDefinition::selectValidation)).setter(RegistrationFieldDefinition.setter(Builder::selectValidation)).constructor(SelectValidation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectValidation").build()}).build();
    private static final SdkField<TextValidation> TEXT_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TextValidation").getter(RegistrationFieldDefinition.getter(RegistrationFieldDefinition::textValidation)).setter(RegistrationFieldDefinition.setter(Builder::textValidation)).constructor(TextValidation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextValidation").build()}).build();
    private static final SdkField<RegistrationFieldDisplayHints> DISPLAY_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisplayHints").getter(RegistrationFieldDefinition.getter(RegistrationFieldDefinition::displayHints)).setter(RegistrationFieldDefinition.setter(Builder::displayHints)).constructor(RegistrationFieldDisplayHints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayHints").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECTION_PATH_FIELD, FIELD_PATH_FIELD, FIELD_TYPE_FIELD, FIELD_REQUIREMENT_FIELD, SELECT_VALIDATION_FIELD, TEXT_VALIDATION_FIELD, DISPLAY_HINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegistrationFieldDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sectionPath;
    private final String fieldPath;
    private final String fieldType;
    private final String fieldRequirement;
    private final SelectValidation selectValidation;
    private final TextValidation textValidation;
    private final RegistrationFieldDisplayHints displayHints;

    private RegistrationFieldDefinition(BuilderImpl builder) {
        this.sectionPath = builder.sectionPath;
        this.fieldPath = builder.fieldPath;
        this.fieldType = builder.fieldType;
        this.fieldRequirement = builder.fieldRequirement;
        this.selectValidation = builder.selectValidation;
        this.textValidation = builder.textValidation;
        this.displayHints = builder.displayHints;
    }

    public final String sectionPath() {
        return this.sectionPath;
    }

    public final String fieldPath() {
        return this.fieldPath;
    }

    public final FieldType fieldType() {
        return FieldType.fromValue(this.fieldType);
    }

    public final String fieldTypeAsString() {
        return this.fieldType;
    }

    public final FieldRequirement fieldRequirement() {
        return FieldRequirement.fromValue(this.fieldRequirement);
    }

    public final String fieldRequirementAsString() {
        return this.fieldRequirement;
    }

    public final SelectValidation selectValidation() {
        return this.selectValidation;
    }

    public final TextValidation textValidation() {
        return this.textValidation;
    }

    public final RegistrationFieldDisplayHints displayHints() {
        return this.displayHints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sectionPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldRequirementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectValidation());
        hashCode = 31 * hashCode + Objects.hashCode(this.textValidation());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayHints());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistrationFieldDefinition)) {
            return false;
        }
        RegistrationFieldDefinition other = (RegistrationFieldDefinition)obj;
        return Objects.equals(this.sectionPath(), other.sectionPath()) && Objects.equals(this.fieldPath(), other.fieldPath()) && Objects.equals(this.fieldTypeAsString(), other.fieldTypeAsString()) && Objects.equals(this.fieldRequirementAsString(), other.fieldRequirementAsString()) && Objects.equals(this.selectValidation(), other.selectValidation()) && Objects.equals(this.textValidation(), other.textValidation()) && Objects.equals(this.displayHints(), other.displayHints());
    }

    public final String toString() {
        return ToString.builder((String)"RegistrationFieldDefinition").add("SectionPath", (Object)this.sectionPath()).add("FieldPath", (Object)this.fieldPath()).add("FieldType", (Object)this.fieldTypeAsString()).add("FieldRequirement", (Object)this.fieldRequirementAsString()).add("SelectValidation", (Object)this.selectValidation()).add("TextValidation", (Object)this.textValidation()).add("DisplayHints", (Object)this.displayHints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SectionPath": {
                return Optional.ofNullable(clazz.cast(this.sectionPath()));
            }
            case "FieldPath": {
                return Optional.ofNullable(clazz.cast(this.fieldPath()));
            }
            case "FieldType": {
                return Optional.ofNullable(clazz.cast(this.fieldTypeAsString()));
            }
            case "FieldRequirement": {
                return Optional.ofNullable(clazz.cast(this.fieldRequirementAsString()));
            }
            case "SelectValidation": {
                return Optional.ofNullable(clazz.cast(this.selectValidation()));
            }
            case "TextValidation": {
                return Optional.ofNullable(clazz.cast(this.textValidation()));
            }
            case "DisplayHints": {
                return Optional.ofNullable(clazz.cast(this.displayHints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SectionPath", SECTION_PATH_FIELD);
        map.put("FieldPath", FIELD_PATH_FIELD);
        map.put("FieldType", FIELD_TYPE_FIELD);
        map.put("FieldRequirement", FIELD_REQUIREMENT_FIELD);
        map.put("SelectValidation", SELECT_VALIDATION_FIELD);
        map.put("TextValidation", TEXT_VALIDATION_FIELD);
        map.put("DisplayHints", DISPLAY_HINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegistrationFieldDefinition, T> g) {
        return obj -> g.apply((RegistrationFieldDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sectionPath;
        private String fieldPath;
        private String fieldType;
        private String fieldRequirement;
        private SelectValidation selectValidation;
        private TextValidation textValidation;
        private RegistrationFieldDisplayHints displayHints;

        private BuilderImpl() {
        }

        private BuilderImpl(RegistrationFieldDefinition model) {
            this.sectionPath(model.sectionPath);
            this.fieldPath(model.fieldPath);
            this.fieldType(model.fieldType);
            this.fieldRequirement(model.fieldRequirement);
            this.selectValidation(model.selectValidation);
            this.textValidation(model.textValidation);
            this.displayHints(model.displayHints);
        }

        public final String getSectionPath() {
            return this.sectionPath;
        }

        public final void setSectionPath(String sectionPath) {
            this.sectionPath = sectionPath;
        }

        @Override
        public final Builder sectionPath(String sectionPath) {
            this.sectionPath = sectionPath;
            return this;
        }

        public final String getFieldPath() {
            return this.fieldPath;
        }

        public final void setFieldPath(String fieldPath) {
            this.fieldPath = fieldPath;
        }

        @Override
        public final Builder fieldPath(String fieldPath) {
            this.fieldPath = fieldPath;
            return this;
        }

        public final String getFieldType() {
            return this.fieldType;
        }

        public final void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        @Override
        public final Builder fieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        @Override
        public final Builder fieldType(FieldType fieldType) {
            this.fieldType(fieldType == null ? null : fieldType.toString());
            return this;
        }

        public final String getFieldRequirement() {
            return this.fieldRequirement;
        }

        public final void setFieldRequirement(String fieldRequirement) {
            this.fieldRequirement = fieldRequirement;
        }

        @Override
        public final Builder fieldRequirement(String fieldRequirement) {
            this.fieldRequirement = fieldRequirement;
            return this;
        }

        @Override
        public final Builder fieldRequirement(FieldRequirement fieldRequirement) {
            this.fieldRequirement(fieldRequirement == null ? null : fieldRequirement.toString());
            return this;
        }

        public final SelectValidation.Builder getSelectValidation() {
            return this.selectValidation != null ? this.selectValidation.toBuilder() : null;
        }

        public final void setSelectValidation(SelectValidation.BuilderImpl selectValidation) {
            this.selectValidation = selectValidation != null ? selectValidation.build() : null;
        }

        @Override
        public final Builder selectValidation(SelectValidation selectValidation) {
            this.selectValidation = selectValidation;
            return this;
        }

        public final TextValidation.Builder getTextValidation() {
            return this.textValidation != null ? this.textValidation.toBuilder() : null;
        }

        public final void setTextValidation(TextValidation.BuilderImpl textValidation) {
            this.textValidation = textValidation != null ? textValidation.build() : null;
        }

        @Override
        public final Builder textValidation(TextValidation textValidation) {
            this.textValidation = textValidation;
            return this;
        }

        public final RegistrationFieldDisplayHints.Builder getDisplayHints() {
            return this.displayHints != null ? this.displayHints.toBuilder() : null;
        }

        public final void setDisplayHints(RegistrationFieldDisplayHints.BuilderImpl displayHints) {
            this.displayHints = displayHints != null ? displayHints.build() : null;
        }

        @Override
        public final Builder displayHints(RegistrationFieldDisplayHints displayHints) {
            this.displayHints = displayHints;
            return this;
        }

        public RegistrationFieldDefinition build() {
            return new RegistrationFieldDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegistrationFieldDefinition> {
        public Builder sectionPath(String var1);

        public Builder fieldPath(String var1);

        public Builder fieldType(String var1);

        public Builder fieldType(FieldType var1);

        public Builder fieldRequirement(String var1);

        public Builder fieldRequirement(FieldRequirement var1);

        public Builder selectValidation(SelectValidation var1);

        default public Builder selectValidation(Consumer<SelectValidation.Builder> selectValidation) {
            return this.selectValidation((SelectValidation)((SelectValidation.Builder)SelectValidation.builder().applyMutation(selectValidation)).build());
        }

        public Builder textValidation(TextValidation var1);

        default public Builder textValidation(Consumer<TextValidation.Builder> textValidation) {
            return this.textValidation((TextValidation)((TextValidation.Builder)TextValidation.builder().applyMutation(textValidation)).build());
        }

        public Builder displayHints(RegistrationFieldDisplayHints var1);

        default public Builder displayHints(Consumer<RegistrationFieldDisplayHints.Builder> displayHints) {
            return this.displayHints((RegistrationFieldDisplayHints)((RegistrationFieldDisplayHints.Builder)RegistrationFieldDisplayHints.builder().applyMutation(displayHints)).build());
        }
    }
}

