/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolInformation;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolInformationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePoolsResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, DescribePoolsResponse> {
    private static final SdkField<List<PoolInformation>> POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Pools").getter(DescribePoolsResponse.getter(DescribePoolsResponse::pools)).setter(DescribePoolsResponse.setter(Builder::pools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PoolInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribePoolsResponse.getter(DescribePoolsResponse::nextToken)).setter(DescribePoolsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOLS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribePoolsResponse.memberNameToFieldInitializer();
    private final List<PoolInformation> pools;
    private final String nextToken;

    private DescribePoolsResponse(BuilderImpl builder) {
        super(builder);
        this.pools = builder.pools;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPools() {
        return this.pools != null && !(this.pools instanceof SdkAutoConstructList);
    }

    public final List<PoolInformation> pools() {
        return this.pools;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPools() ? this.pools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePoolsResponse)) {
            return false;
        }
        DescribePoolsResponse other = (DescribePoolsResponse)((Object)obj);
        return this.hasPools() == other.hasPools() && Objects.equals(this.pools(), other.pools()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePoolsResponse").add("Pools", this.hasPools() ? this.pools() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Pools": {
                return Optional.ofNullable(clazz.cast(this.pools()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Pools", POOLS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePoolsResponse, T> g) {
        return obj -> g.apply((DescribePoolsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private List<PoolInformation> pools = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePoolsResponse model) {
            super(model);
            this.pools(model.pools);
            this.nextToken(model.nextToken);
        }

        public final List<PoolInformation.Builder> getPools() {
            List<PoolInformation.Builder> result = PoolInformationListCopier.copyToBuilder(this.pools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPools(Collection<PoolInformation.BuilderImpl> pools) {
            this.pools = PoolInformationListCopier.copyFromBuilder(pools);
        }

        @Override
        public final Builder pools(Collection<PoolInformation> pools) {
            this.pools = PoolInformationListCopier.copy(pools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pools(PoolInformation ... pools) {
            this.pools(Arrays.asList(pools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pools(Consumer<PoolInformation.Builder> ... pools) {
            this.pools(Stream.of(pools).map(c -> (PoolInformation)((PoolInformation.Builder)PoolInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribePoolsResponse build() {
            return new DescribePoolsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePoolsResponse> {
        public Builder pools(Collection<PoolInformation> var1);

        public Builder pools(PoolInformation ... var1);

        public Builder pools(Consumer<PoolInformation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

