/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2AsyncClient;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAttachmentsInformation;

public class DescribeRegistrationAttachmentsPublisher
implements SdkPublisher<DescribeRegistrationAttachmentsResponse> {
    private final PinpointSmsVoiceV2AsyncClient client;
    private final DescribeRegistrationAttachmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRegistrationAttachmentsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeRegistrationAttachmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRegistrationAttachmentsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeRegistrationAttachmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRegistrationAttachmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRegistrationAttachmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RegistrationAttachmentsInformation> registrationAttachments() {
        Function<DescribeRegistrationAttachmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.registrationAttachments() != null) {
                return response.registrationAttachments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeRegistrationAttachmentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeRegistrationAttachmentsResponseFetcher
    implements AsyncPageFetcher<DescribeRegistrationAttachmentsResponse> {
        private DescribeRegistrationAttachmentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRegistrationAttachmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRegistrationAttachmentsResponse> nextPage(DescribeRegistrationAttachmentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRegistrationAttachmentsPublisher.this.client.describeRegistrationAttachments(DescribeRegistrationAttachmentsPublisher.this.firstRequest);
            }
            return DescribeRegistrationAttachmentsPublisher.this.client.describeRegistrationAttachments((DescribeRegistrationAttachmentsRequest)((Object)DescribeRegistrationAttachmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

