/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AccountLimit;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse;

public class DescribeAccountLimitsIterable
implements SdkIterable<DescribeAccountLimitsResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final DescribeAccountLimitsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAccountLimitsIterable(PinpointSmsVoiceV2Client client, DescribeAccountLimitsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeAccountLimitsResponseFetcher();
    }

    public Iterator<DescribeAccountLimitsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountLimit> accountLimits() {
        Function<DescribeAccountLimitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountLimits() != null) {
                return response.accountLimits().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAccountLimitsResponseFetcher
    implements SyncPageFetcher<DescribeAccountLimitsResponse> {
        private DescribeAccountLimitsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAccountLimitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAccountLimitsResponse nextPage(DescribeAccountLimitsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAccountLimitsIterable.this.client.describeAccountLimits(DescribeAccountLimitsIterable.this.firstRequest);
            }
            return DescribeAccountLimitsIterable.this.client.describeAccountLimits((DescribeAccountLimitsRequest)((Object)DescribeAccountLimitsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

