/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationFieldValueInformation;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationFieldValueInformationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRegistrationFieldValuesResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, DescribeRegistrationFieldValuesResponse> {
    private static final SdkField<String> REGISTRATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationArn").getter(DescribeRegistrationFieldValuesResponse.getter(DescribeRegistrationFieldValuesResponse::registrationArn)).setter(DescribeRegistrationFieldValuesResponse.setter(Builder::registrationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationArn").build()}).build();
    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationId").getter(DescribeRegistrationFieldValuesResponse.getter(DescribeRegistrationFieldValuesResponse::registrationId)).setter(DescribeRegistrationFieldValuesResponse.setter(Builder::registrationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationId").build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VersionNumber").getter(DescribeRegistrationFieldValuesResponse.getter(DescribeRegistrationFieldValuesResponse::versionNumber)).setter(DescribeRegistrationFieldValuesResponse.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()}).build();
    private static final SdkField<List<RegistrationFieldValueInformation>> REGISTRATION_FIELD_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegistrationFieldValues").getter(DescribeRegistrationFieldValuesResponse.getter(DescribeRegistrationFieldValuesResponse::registrationFieldValues)).setter(DescribeRegistrationFieldValuesResponse.setter(Builder::registrationFieldValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationFieldValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegistrationFieldValueInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeRegistrationFieldValuesResponse.getter(DescribeRegistrationFieldValuesResponse::nextToken)).setter(DescribeRegistrationFieldValuesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_ARN_FIELD, REGISTRATION_ID_FIELD, VERSION_NUMBER_FIELD, REGISTRATION_FIELD_VALUES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeRegistrationFieldValuesResponse.memberNameToFieldInitializer();
    private final String registrationArn;
    private final String registrationId;
    private final Long versionNumber;
    private final List<RegistrationFieldValueInformation> registrationFieldValues;
    private final String nextToken;

    private DescribeRegistrationFieldValuesResponse(BuilderImpl builder) {
        super(builder);
        this.registrationArn = builder.registrationArn;
        this.registrationId = builder.registrationId;
        this.versionNumber = builder.versionNumber;
        this.registrationFieldValues = builder.registrationFieldValues;
        this.nextToken = builder.nextToken;
    }

    public final String registrationArn() {
        return this.registrationArn;
    }

    public final String registrationId() {
        return this.registrationId;
    }

    public final Long versionNumber() {
        return this.versionNumber;
    }

    public final boolean hasRegistrationFieldValues() {
        return this.registrationFieldValues != null && !(this.registrationFieldValues instanceof SdkAutoConstructList);
    }

    public final List<RegistrationFieldValueInformation> registrationFieldValues() {
        return this.registrationFieldValues;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegistrationFieldValues() ? this.registrationFieldValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistrationFieldValuesResponse)) {
            return false;
        }
        DescribeRegistrationFieldValuesResponse other = (DescribeRegistrationFieldValuesResponse)((Object)obj);
        return Objects.equals(this.registrationArn(), other.registrationArn()) && Objects.equals(this.registrationId(), other.registrationId()) && Objects.equals(this.versionNumber(), other.versionNumber()) && this.hasRegistrationFieldValues() == other.hasRegistrationFieldValues() && Objects.equals(this.registrationFieldValues(), other.registrationFieldValues()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRegistrationFieldValuesResponse").add("RegistrationArn", (Object)this.registrationArn()).add("RegistrationId", (Object)this.registrationId()).add("VersionNumber", (Object)this.versionNumber()).add("RegistrationFieldValues", this.hasRegistrationFieldValues() ? this.registrationFieldValues() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistrationArn": {
                return Optional.ofNullable(clazz.cast(this.registrationArn()));
            }
            case "RegistrationId": {
                return Optional.ofNullable(clazz.cast(this.registrationId()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
            case "RegistrationFieldValues": {
                return Optional.ofNullable(clazz.cast(this.registrationFieldValues()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RegistrationArn", REGISTRATION_ARN_FIELD);
        map.put("RegistrationId", REGISTRATION_ID_FIELD);
        map.put("VersionNumber", VERSION_NUMBER_FIELD);
        map.put("RegistrationFieldValues", REGISTRATION_FIELD_VALUES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegistrationFieldValuesResponse, T> g) {
        return obj -> g.apply((DescribeRegistrationFieldValuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private String registrationArn;
        private String registrationId;
        private Long versionNumber;
        private List<RegistrationFieldValueInformation> registrationFieldValues = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegistrationFieldValuesResponse model) {
            super(model);
            this.registrationArn(model.registrationArn);
            this.registrationId(model.registrationId);
            this.versionNumber(model.versionNumber);
            this.registrationFieldValues(model.registrationFieldValues);
            this.nextToken(model.nextToken);
        }

        public final String getRegistrationArn() {
            return this.registrationArn;
        }

        public final void setRegistrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
        }

        @Override
        public final Builder registrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
            return this;
        }

        public final String getRegistrationId() {
            return this.registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final List<RegistrationFieldValueInformation.Builder> getRegistrationFieldValues() {
            List<RegistrationFieldValueInformation.Builder> result = RegistrationFieldValueInformationListCopier.copyToBuilder(this.registrationFieldValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistrationFieldValues(Collection<RegistrationFieldValueInformation.BuilderImpl> registrationFieldValues) {
            this.registrationFieldValues = RegistrationFieldValueInformationListCopier.copyFromBuilder(registrationFieldValues);
        }

        @Override
        public final Builder registrationFieldValues(Collection<RegistrationFieldValueInformation> registrationFieldValues) {
            this.registrationFieldValues = RegistrationFieldValueInformationListCopier.copy(registrationFieldValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationFieldValues(RegistrationFieldValueInformation ... registrationFieldValues) {
            this.registrationFieldValues(Arrays.asList(registrationFieldValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationFieldValues(Consumer<RegistrationFieldValueInformation.Builder> ... registrationFieldValues) {
            this.registrationFieldValues(Stream.of(registrationFieldValues).map(c -> (RegistrationFieldValueInformation)((RegistrationFieldValueInformation.Builder)RegistrationFieldValueInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRegistrationFieldValuesResponse build() {
            return new DescribeRegistrationFieldValuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRegistrationFieldValuesResponse> {
        public Builder registrationArn(String var1);

        public Builder registrationId(String var1);

        public Builder versionNumber(Long var1);

        public Builder registrationFieldValues(Collection<RegistrationFieldValueInformation> var1);

        public Builder registrationFieldValues(RegistrationFieldValueInformation ... var1);

        public Builder registrationFieldValues(Consumer<RegistrationFieldValueInformation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

