/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ContextMapCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DestinationCountryParameterKey;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DestinationCountryParametersCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.LanguageCode;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerificationChannel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendDestinationNumberVerificationCodeRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, SendDestinationNumberVerificationCodeRequest> {
    private static final SdkField<String> VERIFIED_DESTINATION_NUMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedDestinationNumberId").getter(SendDestinationNumberVerificationCodeRequest.getter(SendDestinationNumberVerificationCodeRequest::verifiedDestinationNumberId)).setter(SendDestinationNumberVerificationCodeRequest.setter(Builder::verifiedDestinationNumberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedDestinationNumberId").build()}).build();
    private static final SdkField<String> VERIFICATION_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerificationChannel").getter(SendDestinationNumberVerificationCodeRequest.getter(SendDestinationNumberVerificationCodeRequest::verificationChannelAsString)).setter(SendDestinationNumberVerificationCodeRequest.setter(Builder::verificationChannel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationChannel").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(SendDestinationNumberVerificationCodeRequest.getter(SendDestinationNumberVerificationCodeRequest::languageCodeAsString)).setter(SendDestinationNumberVerificationCodeRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> ORIGINATION_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginationIdentity").getter(SendDestinationNumberVerificationCodeRequest.getter(SendDestinationNumberVerificationCodeRequest::originationIdentity)).setter(SendDestinationNumberVerificationCodeRequest.setter(Builder::originationIdentity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentity").build()}).build();
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(SendDestinationNumberVerificationCodeRequest.getter(SendDestinationNumberVerificationCodeRequest::configurationSetName)).setter(SendDestinationNumberVerificationCodeRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build()}).build();
    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Context").getter(SendDestinationNumberVerificationCodeRequest.getter(SendDestinationNumberVerificationCodeRequest::context)).setter(SendDestinationNumberVerificationCodeRequest.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> DESTINATION_COUNTRY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DestinationCountryParameters").getter(SendDestinationNumberVerificationCodeRequest.getter(SendDestinationNumberVerificationCodeRequest::destinationCountryParametersAsStrings)).setter(SendDestinationNumberVerificationCodeRequest.setter(Builder::destinationCountryParametersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCountryParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_DESTINATION_NUMBER_ID_FIELD, VERIFICATION_CHANNEL_FIELD, LANGUAGE_CODE_FIELD, ORIGINATION_IDENTITY_FIELD, CONFIGURATION_SET_NAME_FIELD, CONTEXT_FIELD, DESTINATION_COUNTRY_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VerifiedDestinationNumberId", VERIFIED_DESTINATION_NUMBER_ID_FIELD);
            this.put("VerificationChannel", VERIFICATION_CHANNEL_FIELD);
            this.put("LanguageCode", LANGUAGE_CODE_FIELD);
            this.put("OriginationIdentity", ORIGINATION_IDENTITY_FIELD);
            this.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
            this.put("Context", CONTEXT_FIELD);
            this.put("DestinationCountryParameters", DESTINATION_COUNTRY_PARAMETERS_FIELD);
        }
    });
    private final String verifiedDestinationNumberId;
    private final String verificationChannel;
    private final String languageCode;
    private final String originationIdentity;
    private final String configurationSetName;
    private final Map<String, String> context;
    private final Map<String, String> destinationCountryParameters;

    private SendDestinationNumberVerificationCodeRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedDestinationNumberId = builder.verifiedDestinationNumberId;
        this.verificationChannel = builder.verificationChannel;
        this.languageCode = builder.languageCode;
        this.originationIdentity = builder.originationIdentity;
        this.configurationSetName = builder.configurationSetName;
        this.context = builder.context;
        this.destinationCountryParameters = builder.destinationCountryParameters;
    }

    public final String verifiedDestinationNumberId() {
        return this.verifiedDestinationNumberId;
    }

    public final VerificationChannel verificationChannel() {
        return VerificationChannel.fromValue(this.verificationChannel);
    }

    public final String verificationChannelAsString() {
        return this.verificationChannel;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final String originationIdentity() {
        return this.originationIdentity;
    }

    public final String configurationSetName() {
        return this.configurationSetName;
    }

    public final boolean hasContext() {
        return this.context != null && !(this.context instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> context() {
        return this.context;
    }

    public final Map<DestinationCountryParameterKey, String> destinationCountryParameters() {
        return DestinationCountryParametersCopier.copyStringToEnum(this.destinationCountryParameters);
    }

    public final boolean hasDestinationCountryParameters() {
        return this.destinationCountryParameters != null && !(this.destinationCountryParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> destinationCountryParametersAsStrings() {
        return this.destinationCountryParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedDestinationNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationChannelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.originationIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContext() ? this.context() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationCountryParameters() ? this.destinationCountryParametersAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendDestinationNumberVerificationCodeRequest)) {
            return false;
        }
        SendDestinationNumberVerificationCodeRequest other = (SendDestinationNumberVerificationCodeRequest)((Object)obj);
        return Objects.equals(this.verifiedDestinationNumberId(), other.verifiedDestinationNumberId()) && Objects.equals(this.verificationChannelAsString(), other.verificationChannelAsString()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.originationIdentity(), other.originationIdentity()) && Objects.equals(this.configurationSetName(), other.configurationSetName()) && this.hasContext() == other.hasContext() && Objects.equals(this.context(), other.context()) && this.hasDestinationCountryParameters() == other.hasDestinationCountryParameters() && Objects.equals(this.destinationCountryParametersAsStrings(), other.destinationCountryParametersAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"SendDestinationNumberVerificationCodeRequest").add("VerifiedDestinationNumberId", (Object)this.verifiedDestinationNumberId()).add("VerificationChannel", (Object)this.verificationChannelAsString()).add("LanguageCode", (Object)this.languageCodeAsString()).add("OriginationIdentity", (Object)this.originationIdentity()).add("ConfigurationSetName", (Object)this.configurationSetName()).add("Context", this.hasContext() ? this.context() : null).add("DestinationCountryParameters", this.hasDestinationCountryParameters() ? this.destinationCountryParametersAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedDestinationNumberId": {
                return Optional.ofNullable(clazz.cast(this.verifiedDestinationNumberId()));
            }
            case "VerificationChannel": {
                return Optional.ofNullable(clazz.cast(this.verificationChannelAsString()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "OriginationIdentity": {
                return Optional.ofNullable(clazz.cast(this.originationIdentity()));
            }
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "DestinationCountryParameters": {
                return Optional.ofNullable(clazz.cast(this.destinationCountryParametersAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SendDestinationNumberVerificationCodeRequest, T> g) {
        return obj -> g.apply((SendDestinationNumberVerificationCodeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private String verifiedDestinationNumberId;
        private String verificationChannel;
        private String languageCode;
        private String originationIdentity;
        private String configurationSetName;
        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> destinationCountryParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendDestinationNumberVerificationCodeRequest model) {
            super(model);
            this.verifiedDestinationNumberId(model.verifiedDestinationNumberId);
            this.verificationChannel(model.verificationChannel);
            this.languageCode(model.languageCode);
            this.originationIdentity(model.originationIdentity);
            this.configurationSetName(model.configurationSetName);
            this.context(model.context);
            this.destinationCountryParametersWithStrings(model.destinationCountryParameters);
        }

        public final String getVerifiedDestinationNumberId() {
            return this.verifiedDestinationNumberId;
        }

        public final void setVerifiedDestinationNumberId(String verifiedDestinationNumberId) {
            this.verifiedDestinationNumberId = verifiedDestinationNumberId;
        }

        @Override
        public final Builder verifiedDestinationNumberId(String verifiedDestinationNumberId) {
            this.verifiedDestinationNumberId = verifiedDestinationNumberId;
            return this;
        }

        public final String getVerificationChannel() {
            return this.verificationChannel;
        }

        public final void setVerificationChannel(String verificationChannel) {
            this.verificationChannel = verificationChannel;
        }

        @Override
        public final Builder verificationChannel(String verificationChannel) {
            this.verificationChannel = verificationChannel;
            return this;
        }

        @Override
        public final Builder verificationChannel(VerificationChannel verificationChannel) {
            this.verificationChannel(verificationChannel == null ? null : verificationChannel.toString());
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getOriginationIdentity() {
            return this.originationIdentity;
        }

        public final void setOriginationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
        }

        @Override
        public final Builder originationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
            return this;
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final Map<String, String> getContext() {
            if (this.context instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.context;
        }

        public final void setContext(Map<String, String> context) {
            this.context = ContextMapCopier.copy(context);
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = ContextMapCopier.copy(context);
            return this;
        }

        public final Map<String, String> getDestinationCountryParameters() {
            if (this.destinationCountryParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.destinationCountryParameters;
        }

        public final void setDestinationCountryParameters(Map<String, String> destinationCountryParameters) {
            this.destinationCountryParameters = DestinationCountryParametersCopier.copy(destinationCountryParameters);
        }

        @Override
        public final Builder destinationCountryParametersWithStrings(Map<String, String> destinationCountryParameters) {
            this.destinationCountryParameters = DestinationCountryParametersCopier.copy(destinationCountryParameters);
            return this;
        }

        @Override
        public final Builder destinationCountryParameters(Map<DestinationCountryParameterKey, String> destinationCountryParameters) {
            this.destinationCountryParameters = DestinationCountryParametersCopier.copyEnumToString(destinationCountryParameters);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendDestinationNumberVerificationCodeRequest build() {
            return new SendDestinationNumberVerificationCodeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendDestinationNumberVerificationCodeRequest> {
        public Builder verifiedDestinationNumberId(String var1);

        public Builder verificationChannel(String var1);

        public Builder verificationChannel(VerificationChannel var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder originationIdentity(String var1);

        public Builder configurationSetName(String var1);

        public Builder context(Map<String, String> var1);

        public Builder destinationCountryParametersWithStrings(Map<String, String> var1);

        public Builder destinationCountryParameters(Map<DestinationCountryParameterKey, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

