/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SectionPathListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRegistrationSectionDefinitionsRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, DescribeRegistrationSectionDefinitionsRequest> {
    private static final SdkField<String> REGISTRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationType").getter(DescribeRegistrationSectionDefinitionsRequest.getter(DescribeRegistrationSectionDefinitionsRequest::registrationType)).setter(DescribeRegistrationSectionDefinitionsRequest.setter(Builder::registrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationType").build()}).build();
    private static final SdkField<List<String>> SECTION_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SectionPaths").getter(DescribeRegistrationSectionDefinitionsRequest.getter(DescribeRegistrationSectionDefinitionsRequest::sectionPaths)).setter(DescribeRegistrationSectionDefinitionsRequest.setter(Builder::sectionPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SectionPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeRegistrationSectionDefinitionsRequest.getter(DescribeRegistrationSectionDefinitionsRequest::nextToken)).setter(DescribeRegistrationSectionDefinitionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeRegistrationSectionDefinitionsRequest.getter(DescribeRegistrationSectionDefinitionsRequest::maxResults)).setter(DescribeRegistrationSectionDefinitionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_TYPE_FIELD, SECTION_PATHS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RegistrationType", REGISTRATION_TYPE_FIELD);
            this.put("SectionPaths", SECTION_PATHS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
        }
    });
    private final String registrationType;
    private final List<String> sectionPaths;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeRegistrationSectionDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.registrationType = builder.registrationType;
        this.sectionPaths = builder.sectionPaths;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String registrationType() {
        return this.registrationType;
    }

    public final boolean hasSectionPaths() {
        return this.sectionPaths != null && !(this.sectionPaths instanceof SdkAutoConstructList);
    }

    public final List<String> sectionPaths() {
        return this.sectionPaths;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSectionPaths() ? this.sectionPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistrationSectionDefinitionsRequest)) {
            return false;
        }
        DescribeRegistrationSectionDefinitionsRequest other = (DescribeRegistrationSectionDefinitionsRequest)((Object)obj);
        return Objects.equals(this.registrationType(), other.registrationType()) && this.hasSectionPaths() == other.hasSectionPaths() && Objects.equals(this.sectionPaths(), other.sectionPaths()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRegistrationSectionDefinitionsRequest").add("RegistrationType", (Object)this.registrationType()).add("SectionPaths", this.hasSectionPaths() ? this.sectionPaths() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistrationType": {
                return Optional.ofNullable(clazz.cast(this.registrationType()));
            }
            case "SectionPaths": {
                return Optional.ofNullable(clazz.cast(this.sectionPaths()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegistrationSectionDefinitionsRequest, T> g) {
        return obj -> g.apply((DescribeRegistrationSectionDefinitionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private String registrationType;
        private List<String> sectionPaths = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegistrationSectionDefinitionsRequest model) {
            super(model);
            this.registrationType(model.registrationType);
            this.sectionPaths(model.sectionPaths);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getRegistrationType() {
            return this.registrationType;
        }

        public final void setRegistrationType(String registrationType) {
            this.registrationType = registrationType;
        }

        @Override
        public final Builder registrationType(String registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        public final Collection<String> getSectionPaths() {
            if (this.sectionPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sectionPaths;
        }

        public final void setSectionPaths(Collection<String> sectionPaths) {
            this.sectionPaths = SectionPathListCopier.copy(sectionPaths);
        }

        @Override
        public final Builder sectionPaths(Collection<String> sectionPaths) {
            this.sectionPaths = SectionPathListCopier.copy(sectionPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sectionPaths(String ... sectionPaths) {
            this.sectionPaths(Arrays.asList(sectionPaths));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRegistrationSectionDefinitionsRequest build() {
            return new DescribeRegistrationSectionDefinitionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRegistrationSectionDefinitionsRequest> {
        public Builder registrationType(String var1);

        public Builder sectionPaths(Collection<String> var1);

        public Builder sectionPaths(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

