/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordInformation;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordInformationListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeKeywordsResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, DescribeKeywordsResponse> {
    private static final SdkField<String> ORIGINATION_IDENTITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginationIdentityArn").getter(DescribeKeywordsResponse.getter(DescribeKeywordsResponse::originationIdentityArn)).setter(DescribeKeywordsResponse.setter(Builder::originationIdentityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentityArn").build()}).build();
    private static final SdkField<String> ORIGINATION_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginationIdentity").getter(DescribeKeywordsResponse.getter(DescribeKeywordsResponse::originationIdentity)).setter(DescribeKeywordsResponse.setter(Builder::originationIdentity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentity").build()}).build();
    private static final SdkField<List<KeywordInformation>> KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Keywords").getter(DescribeKeywordsResponse.getter(DescribeKeywordsResponse::keywords)).setter(DescribeKeywordsResponse.setter(Builder::keywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keywords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeywordInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeKeywordsResponse.getter(DescribeKeywordsResponse::nextToken)).setter(DescribeKeywordsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGINATION_IDENTITY_ARN_FIELD, ORIGINATION_IDENTITY_FIELD, KEYWORDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeKeywordsResponse.memberNameToFieldInitializer();
    private final String originationIdentityArn;
    private final String originationIdentity;
    private final List<KeywordInformation> keywords;
    private final String nextToken;

    private DescribeKeywordsResponse(BuilderImpl builder) {
        super(builder);
        this.originationIdentityArn = builder.originationIdentityArn;
        this.originationIdentity = builder.originationIdentity;
        this.keywords = builder.keywords;
        this.nextToken = builder.nextToken;
    }

    public final String originationIdentityArn() {
        return this.originationIdentityArn;
    }

    public final String originationIdentity() {
        return this.originationIdentity;
    }

    public final boolean hasKeywords() {
        return this.keywords != null && !(this.keywords instanceof SdkAutoConstructList);
    }

    public final List<KeywordInformation> keywords() {
        return this.keywords;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.originationIdentityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.originationIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeywords() ? this.keywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeywordsResponse)) {
            return false;
        }
        DescribeKeywordsResponse other = (DescribeKeywordsResponse)((Object)obj);
        return Objects.equals(this.originationIdentityArn(), other.originationIdentityArn()) && Objects.equals(this.originationIdentity(), other.originationIdentity()) && this.hasKeywords() == other.hasKeywords() && Objects.equals(this.keywords(), other.keywords()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeKeywordsResponse").add("OriginationIdentityArn", (Object)this.originationIdentityArn()).add("OriginationIdentity", (Object)this.originationIdentity()).add("Keywords", this.hasKeywords() ? this.keywords() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OriginationIdentityArn": {
                return Optional.ofNullable(clazz.cast(this.originationIdentityArn()));
            }
            case "OriginationIdentity": {
                return Optional.ofNullable(clazz.cast(this.originationIdentity()));
            }
            case "Keywords": {
                return Optional.ofNullable(clazz.cast(this.keywords()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OriginationIdentityArn", ORIGINATION_IDENTITY_ARN_FIELD);
        map.put("OriginationIdentity", ORIGINATION_IDENTITY_FIELD);
        map.put("Keywords", KEYWORDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeKeywordsResponse, T> g) {
        return obj -> g.apply((DescribeKeywordsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private String originationIdentityArn;
        private String originationIdentity;
        private List<KeywordInformation> keywords = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKeywordsResponse model) {
            super(model);
            this.originationIdentityArn(model.originationIdentityArn);
            this.originationIdentity(model.originationIdentity);
            this.keywords(model.keywords);
            this.nextToken(model.nextToken);
        }

        public final String getOriginationIdentityArn() {
            return this.originationIdentityArn;
        }

        public final void setOriginationIdentityArn(String originationIdentityArn) {
            this.originationIdentityArn = originationIdentityArn;
        }

        @Override
        public final Builder originationIdentityArn(String originationIdentityArn) {
            this.originationIdentityArn = originationIdentityArn;
            return this;
        }

        public final String getOriginationIdentity() {
            return this.originationIdentity;
        }

        public final void setOriginationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
        }

        @Override
        public final Builder originationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
            return this;
        }

        public final List<KeywordInformation.Builder> getKeywords() {
            List<KeywordInformation.Builder> result = KeywordInformationListCopier.copyToBuilder(this.keywords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeywords(Collection<KeywordInformation.BuilderImpl> keywords) {
            this.keywords = KeywordInformationListCopier.copyFromBuilder(keywords);
        }

        @Override
        public final Builder keywords(Collection<KeywordInformation> keywords) {
            this.keywords = KeywordInformationListCopier.copy(keywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keywords(KeywordInformation ... keywords) {
            this.keywords(Arrays.asList(keywords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keywords(Consumer<KeywordInformation.Builder> ... keywords) {
            this.keywords(Stream.of(keywords).map(c -> (KeywordInformation)((KeywordInformation.Builder)KeywordInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeKeywordsResponse build() {
            return new DescribeKeywordsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeKeywordsResponse> {
        public Builder originationIdentityArn(String var1);

        public Builder originationIdentity(String var1);

        public Builder keywords(Collection<KeywordInformation> var1);

        public Builder keywords(KeywordInformation ... var1);

        public Builder keywords(Consumer<KeywordInformation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

