/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SelectChoiceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRegistrationFieldValueRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, PutRegistrationFieldValueRequest> {
    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationId").getter(PutRegistrationFieldValueRequest.getter(PutRegistrationFieldValueRequest::registrationId)).setter(PutRegistrationFieldValueRequest.setter(Builder::registrationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationId").build()}).build();
    private static final SdkField<String> FIELD_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldPath").getter(PutRegistrationFieldValueRequest.getter(PutRegistrationFieldValueRequest::fieldPath)).setter(PutRegistrationFieldValueRequest.setter(Builder::fieldPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldPath").build()}).build();
    private static final SdkField<List<String>> SELECT_CHOICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectChoices").getter(PutRegistrationFieldValueRequest.getter(PutRegistrationFieldValueRequest::selectChoices)).setter(PutRegistrationFieldValueRequest.setter(Builder::selectChoices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectChoices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEXT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextValue").getter(PutRegistrationFieldValueRequest.getter(PutRegistrationFieldValueRequest::textValue)).setter(PutRegistrationFieldValueRequest.setter(Builder::textValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextValue").build()}).build();
    private static final SdkField<String> REGISTRATION_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationAttachmentId").getter(PutRegistrationFieldValueRequest.getter(PutRegistrationFieldValueRequest::registrationAttachmentId)).setter(PutRegistrationFieldValueRequest.setter(Builder::registrationAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationAttachmentId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_ID_FIELD, FIELD_PATH_FIELD, SELECT_CHOICES_FIELD, TEXT_VALUE_FIELD, REGISTRATION_ATTACHMENT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutRegistrationFieldValueRequest.memberNameToFieldInitializer();
    private final String registrationId;
    private final String fieldPath;
    private final List<String> selectChoices;
    private final String textValue;
    private final String registrationAttachmentId;

    private PutRegistrationFieldValueRequest(BuilderImpl builder) {
        super(builder);
        this.registrationId = builder.registrationId;
        this.fieldPath = builder.fieldPath;
        this.selectChoices = builder.selectChoices;
        this.textValue = builder.textValue;
        this.registrationAttachmentId = builder.registrationAttachmentId;
    }

    public final String registrationId() {
        return this.registrationId;
    }

    public final String fieldPath() {
        return this.fieldPath;
    }

    public final boolean hasSelectChoices() {
        return this.selectChoices != null && !(this.selectChoices instanceof SdkAutoConstructList);
    }

    public final List<String> selectChoices() {
        return this.selectChoices;
    }

    public final String textValue() {
        return this.textValue;
    }

    public final String registrationAttachmentId() {
        return this.registrationAttachmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectChoices() ? this.selectChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.textValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationAttachmentId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRegistrationFieldValueRequest)) {
            return false;
        }
        PutRegistrationFieldValueRequest other = (PutRegistrationFieldValueRequest)((Object)obj);
        return Objects.equals(this.registrationId(), other.registrationId()) && Objects.equals(this.fieldPath(), other.fieldPath()) && this.hasSelectChoices() == other.hasSelectChoices() && Objects.equals(this.selectChoices(), other.selectChoices()) && Objects.equals(this.textValue(), other.textValue()) && Objects.equals(this.registrationAttachmentId(), other.registrationAttachmentId());
    }

    public final String toString() {
        return ToString.builder((String)"PutRegistrationFieldValueRequest").add("RegistrationId", (Object)this.registrationId()).add("FieldPath", (Object)this.fieldPath()).add("SelectChoices", this.hasSelectChoices() ? this.selectChoices() : null).add("TextValue", (Object)this.textValue()).add("RegistrationAttachmentId", (Object)this.registrationAttachmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistrationId": {
                return Optional.ofNullable(clazz.cast(this.registrationId()));
            }
            case "FieldPath": {
                return Optional.ofNullable(clazz.cast(this.fieldPath()));
            }
            case "SelectChoices": {
                return Optional.ofNullable(clazz.cast(this.selectChoices()));
            }
            case "TextValue": {
                return Optional.ofNullable(clazz.cast(this.textValue()));
            }
            case "RegistrationAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.registrationAttachmentId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RegistrationId", REGISTRATION_ID_FIELD);
        map.put("FieldPath", FIELD_PATH_FIELD);
        map.put("SelectChoices", SELECT_CHOICES_FIELD);
        map.put("TextValue", TEXT_VALUE_FIELD);
        map.put("RegistrationAttachmentId", REGISTRATION_ATTACHMENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRegistrationFieldValueRequest, T> g) {
        return obj -> g.apply((PutRegistrationFieldValueRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private String registrationId;
        private String fieldPath;
        private List<String> selectChoices = DefaultSdkAutoConstructList.getInstance();
        private String textValue;
        private String registrationAttachmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRegistrationFieldValueRequest model) {
            super(model);
            this.registrationId(model.registrationId);
            this.fieldPath(model.fieldPath);
            this.selectChoices(model.selectChoices);
            this.textValue(model.textValue);
            this.registrationAttachmentId(model.registrationAttachmentId);
        }

        public final String getRegistrationId() {
            return this.registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final String getFieldPath() {
            return this.fieldPath;
        }

        public final void setFieldPath(String fieldPath) {
            this.fieldPath = fieldPath;
        }

        @Override
        public final Builder fieldPath(String fieldPath) {
            this.fieldPath = fieldPath;
            return this;
        }

        public final Collection<String> getSelectChoices() {
            if (this.selectChoices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectChoices;
        }

        public final void setSelectChoices(Collection<String> selectChoices) {
            this.selectChoices = SelectChoiceListCopier.copy(selectChoices);
        }

        @Override
        public final Builder selectChoices(Collection<String> selectChoices) {
            this.selectChoices = SelectChoiceListCopier.copy(selectChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectChoices(String ... selectChoices) {
            this.selectChoices(Arrays.asList(selectChoices));
            return this;
        }

        public final String getTextValue() {
            return this.textValue;
        }

        public final void setTextValue(String textValue) {
            this.textValue = textValue;
        }

        @Override
        public final Builder textValue(String textValue) {
            this.textValue = textValue;
            return this;
        }

        public final String getRegistrationAttachmentId() {
            return this.registrationAttachmentId;
        }

        public final void setRegistrationAttachmentId(String registrationAttachmentId) {
            this.registrationAttachmentId = registrationAttachmentId;
        }

        @Override
        public final Builder registrationAttachmentId(String registrationAttachmentId) {
            this.registrationAttachmentId = registrationAttachmentId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRegistrationFieldValueRequest build() {
            return new PutRegistrationFieldValueRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRegistrationFieldValueRequest> {
        public Builder registrationId(String var1);

        public Builder fieldPath(String var1);

        public Builder selectChoices(Collection<String> var1);

        public Builder selectChoices(String ... var1);

        public Builder textValue(String var1);

        public Builder registrationAttachmentId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

