/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2AsyncClient;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordInformation;

public class DescribeKeywordsPublisher
implements SdkPublisher<DescribeKeywordsResponse> {
    private final PinpointSmsVoiceV2AsyncClient client;
    private final DescribeKeywordsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeKeywordsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeKeywordsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeKeywordsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeKeywordsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeKeywordsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeKeywordsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<KeywordInformation> keywords() {
        Function<DescribeKeywordsResponse, Iterator> getIterator = response -> {
            if (response != null && response.keywords() != null) {
                return response.keywords().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeKeywordsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeKeywordsResponseFetcher
    implements AsyncPageFetcher<DescribeKeywordsResponse> {
        private DescribeKeywordsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeKeywordsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeKeywordsResponse> nextPage(DescribeKeywordsResponse previousPage) {
            if (previousPage == null) {
                return DescribeKeywordsPublisher.this.client.describeKeywords(DescribeKeywordsPublisher.this.firstRequest);
            }
            return DescribeKeywordsPublisher.this.client.describeKeywords((DescribeKeywordsRequest)((Object)DescribeKeywordsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

