/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ContextMapCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DestinationCountryParameterKey;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DestinationCountryParametersCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageType;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendTextMessageRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, SendTextMessageRequest> {
    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPhoneNumber").getter(SendTextMessageRequest.getter(SendTextMessageRequest::destinationPhoneNumber)).setter(SendTextMessageRequest.setter(Builder::destinationPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumber").build()}).build();
    private static final SdkField<String> ORIGINATION_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginationIdentity").getter(SendTextMessageRequest.getter(SendTextMessageRequest::originationIdentity)).setter(SendTextMessageRequest.setter(Builder::originationIdentity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentity").build()}).build();
    private static final SdkField<String> MESSAGE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageBody").getter(SendTextMessageRequest.getter(SendTextMessageRequest::messageBody)).setter(SendTextMessageRequest.setter(Builder::messageBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageBody").build()}).build();
    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageType").getter(SendTextMessageRequest.getter(SendTextMessageRequest::messageTypeAsString)).setter(SendTextMessageRequest.setter(Builder::messageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()}).build();
    private static final SdkField<String> KEYWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Keyword").getter(SendTextMessageRequest.getter(SendTextMessageRequest::keyword)).setter(SendTextMessageRequest.setter(Builder::keyword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keyword").build()}).build();
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(SendTextMessageRequest.getter(SendTextMessageRequest::configurationSetName)).setter(SendTextMessageRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build()}).build();
    private static final SdkField<String> MAX_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxPrice").getter(SendTextMessageRequest.getter(SendTextMessageRequest::maxPrice)).setter(SendTextMessageRequest.setter(Builder::maxPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPrice").build()}).build();
    private static final SdkField<Integer> TIME_TO_LIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeToLive").getter(SendTextMessageRequest.getter(SendTextMessageRequest::timeToLive)).setter(SendTextMessageRequest.setter(Builder::timeToLive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeToLive").build()}).build();
    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Context").getter(SendTextMessageRequest.getter(SendTextMessageRequest::context)).setter(SendTextMessageRequest.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> DESTINATION_COUNTRY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DestinationCountryParameters").getter(SendTextMessageRequest.getter(SendTextMessageRequest::destinationCountryParametersAsStrings)).setter(SendTextMessageRequest.setter(Builder::destinationCountryParametersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCountryParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(SendTextMessageRequest.getter(SendTextMessageRequest::dryRun)).setter(SendTextMessageRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectConfigurationId").getter(SendTextMessageRequest.getter(SendTextMessageRequest::protectConfigurationId)).setter(SendTextMessageRequest.setter(Builder::protectConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_PHONE_NUMBER_FIELD, ORIGINATION_IDENTITY_FIELD, MESSAGE_BODY_FIELD, MESSAGE_TYPE_FIELD, KEYWORD_FIELD, CONFIGURATION_SET_NAME_FIELD, MAX_PRICE_FIELD, TIME_TO_LIVE_FIELD, CONTEXT_FIELD, DESTINATION_COUNTRY_PARAMETERS_FIELD, DRY_RUN_FIELD, PROTECT_CONFIGURATION_ID_FIELD));
    private final String destinationPhoneNumber;
    private final String originationIdentity;
    private final String messageBody;
    private final String messageType;
    private final String keyword;
    private final String configurationSetName;
    private final String maxPrice;
    private final Integer timeToLive;
    private final Map<String, String> context;
    private final Map<String, String> destinationCountryParameters;
    private final Boolean dryRun;
    private final String protectConfigurationId;

    private SendTextMessageRequest(BuilderImpl builder) {
        super(builder);
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.originationIdentity = builder.originationIdentity;
        this.messageBody = builder.messageBody;
        this.messageType = builder.messageType;
        this.keyword = builder.keyword;
        this.configurationSetName = builder.configurationSetName;
        this.maxPrice = builder.maxPrice;
        this.timeToLive = builder.timeToLive;
        this.context = builder.context;
        this.destinationCountryParameters = builder.destinationCountryParameters;
        this.dryRun = builder.dryRun;
        this.protectConfigurationId = builder.protectConfigurationId;
    }

    public final String destinationPhoneNumber() {
        return this.destinationPhoneNumber;
    }

    public final String originationIdentity() {
        return this.originationIdentity;
    }

    public final String messageBody() {
        return this.messageBody;
    }

    public final MessageType messageType() {
        return MessageType.fromValue(this.messageType);
    }

    public final String messageTypeAsString() {
        return this.messageType;
    }

    public final String keyword() {
        return this.keyword;
    }

    public final String configurationSetName() {
        return this.configurationSetName;
    }

    public final String maxPrice() {
        return this.maxPrice;
    }

    public final Integer timeToLive() {
        return this.timeToLive;
    }

    public final boolean hasContext() {
        return this.context != null && !(this.context instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> context() {
        return this.context;
    }

    public final Map<DestinationCountryParameterKey, String> destinationCountryParameters() {
        return DestinationCountryParametersCopier.copyStringToEnum(this.destinationCountryParameters);
    }

    public final boolean hasDestinationCountryParameters() {
        return this.destinationCountryParameters != null && !(this.destinationCountryParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> destinationCountryParametersAsStrings() {
        return this.destinationCountryParameters;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String protectConfigurationId() {
        return this.protectConfigurationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.originationIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyword());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContext() ? this.context() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationCountryParameters() ? this.destinationCountryParametersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectConfigurationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendTextMessageRequest)) {
            return false;
        }
        SendTextMessageRequest other = (SendTextMessageRequest)((Object)obj);
        return Objects.equals(this.destinationPhoneNumber(), other.destinationPhoneNumber()) && Objects.equals(this.originationIdentity(), other.originationIdentity()) && Objects.equals(this.messageBody(), other.messageBody()) && Objects.equals(this.messageTypeAsString(), other.messageTypeAsString()) && Objects.equals(this.keyword(), other.keyword()) && Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.maxPrice(), other.maxPrice()) && Objects.equals(this.timeToLive(), other.timeToLive()) && this.hasContext() == other.hasContext() && Objects.equals(this.context(), other.context()) && this.hasDestinationCountryParameters() == other.hasDestinationCountryParameters() && Objects.equals(this.destinationCountryParametersAsStrings(), other.destinationCountryParametersAsStrings()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.protectConfigurationId(), other.protectConfigurationId());
    }

    public final String toString() {
        return ToString.builder((String)"SendTextMessageRequest").add("DestinationPhoneNumber", (Object)this.destinationPhoneNumber()).add("OriginationIdentity", (Object)this.originationIdentity()).add("MessageBody", (Object)this.messageBody()).add("MessageType", (Object)this.messageTypeAsString()).add("Keyword", (Object)this.keyword()).add("ConfigurationSetName", (Object)this.configurationSetName()).add("MaxPrice", (Object)this.maxPrice()).add("TimeToLive", (Object)this.timeToLive()).add("Context", this.hasContext() ? this.context() : null).add("DestinationCountryParameters", this.hasDestinationCountryParameters() ? this.destinationCountryParametersAsStrings() : null).add("DryRun", (Object)this.dryRun()).add("ProtectConfigurationId", (Object)this.protectConfigurationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.destinationPhoneNumber()));
            }
            case "OriginationIdentity": {
                return Optional.ofNullable(clazz.cast(this.originationIdentity()));
            }
            case "MessageBody": {
                return Optional.ofNullable(clazz.cast(this.messageBody()));
            }
            case "MessageType": {
                return Optional.ofNullable(clazz.cast(this.messageTypeAsString()));
            }
            case "Keyword": {
                return Optional.ofNullable(clazz.cast(this.keyword()));
            }
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "MaxPrice": {
                return Optional.ofNullable(clazz.cast(this.maxPrice()));
            }
            case "TimeToLive": {
                return Optional.ofNullable(clazz.cast(this.timeToLive()));
            }
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "DestinationCountryParameters": {
                return Optional.ofNullable(clazz.cast(this.destinationCountryParametersAsStrings()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "ProtectConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.protectConfigurationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendTextMessageRequest, T> g) {
        return obj -> g.apply((SendTextMessageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private String destinationPhoneNumber;
        private String originationIdentity;
        private String messageBody;
        private String messageType;
        private String keyword;
        private String configurationSetName;
        private String maxPrice;
        private Integer timeToLive;
        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> destinationCountryParameters = DefaultSdkAutoConstructMap.getInstance();
        private Boolean dryRun;
        private String protectConfigurationId;

        private BuilderImpl() {
        }

        private BuilderImpl(SendTextMessageRequest model) {
            super(model);
            this.destinationPhoneNumber(model.destinationPhoneNumber);
            this.originationIdentity(model.originationIdentity);
            this.messageBody(model.messageBody);
            this.messageType(model.messageType);
            this.keyword(model.keyword);
            this.configurationSetName(model.configurationSetName);
            this.maxPrice(model.maxPrice);
            this.timeToLive(model.timeToLive);
            this.context(model.context);
            this.destinationCountryParametersWithStrings(model.destinationCountryParameters);
            this.dryRun(model.dryRun);
            this.protectConfigurationId(model.protectConfigurationId);
        }

        public final String getDestinationPhoneNumber() {
            return this.destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final String getOriginationIdentity() {
            return this.originationIdentity;
        }

        public final void setOriginationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
        }

        @Override
        public final Builder originationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
            return this;
        }

        public final String getMessageBody() {
            return this.messageBody;
        }

        public final void setMessageBody(String messageBody) {
            this.messageBody = messageBody;
        }

        @Override
        public final Builder messageBody(String messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public final String getMessageType() {
            return this.messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final String getKeyword() {
            return this.keyword;
        }

        public final void setKeyword(String keyword) {
            this.keyword = keyword;
        }

        @Override
        public final Builder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final String getMaxPrice() {
            return this.maxPrice;
        }

        public final void setMaxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
        }

        @Override
        public final Builder maxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        public final Integer getTimeToLive() {
            return this.timeToLive;
        }

        public final void setTimeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
        }

        @Override
        public final Builder timeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public final Map<String, String> getContext() {
            if (this.context instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.context;
        }

        public final void setContext(Map<String, String> context) {
            this.context = ContextMapCopier.copy(context);
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = ContextMapCopier.copy(context);
            return this;
        }

        public final Map<String, String> getDestinationCountryParameters() {
            if (this.destinationCountryParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.destinationCountryParameters;
        }

        public final void setDestinationCountryParameters(Map<String, String> destinationCountryParameters) {
            this.destinationCountryParameters = DestinationCountryParametersCopier.copy(destinationCountryParameters);
        }

        @Override
        public final Builder destinationCountryParametersWithStrings(Map<String, String> destinationCountryParameters) {
            this.destinationCountryParameters = DestinationCountryParametersCopier.copy(destinationCountryParameters);
            return this;
        }

        @Override
        public final Builder destinationCountryParameters(Map<DestinationCountryParameterKey, String> destinationCountryParameters) {
            this.destinationCountryParameters = DestinationCountryParametersCopier.copyEnumToString(destinationCountryParameters);
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getProtectConfigurationId() {
            return this.protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendTextMessageRequest build() {
            return new SendTextMessageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendTextMessageRequest> {
        public Builder destinationPhoneNumber(String var1);

        public Builder originationIdentity(String var1);

        public Builder messageBody(String var1);

        public Builder messageType(String var1);

        public Builder messageType(MessageType var1);

        public Builder keyword(String var1);

        public Builder configurationSetName(String var1);

        public Builder maxPrice(String var1);

        public Builder timeToLive(Integer var1);

        public Builder context(Map<String, String> var1);

        public Builder destinationCountryParametersWithStrings(Map<String, String> var1);

        public Builder destinationCountryParameters(Map<DestinationCountryParameterKey, String> var1);

        public Builder dryRun(Boolean var1);

        public Builder protectConfigurationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

