/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.Owner;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PhoneNumberFilter;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PhoneNumberFilterListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PhoneNumberIdListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePhoneNumbersRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, DescribePhoneNumbersRequest> {
    private static final SdkField<List<String>> PHONE_NUMBER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PhoneNumberIds").getter(DescribePhoneNumbersRequest.getter(DescribePhoneNumbersRequest::phoneNumberIds)).setter(DescribePhoneNumbersRequest.setter(Builder::phoneNumberIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PhoneNumberFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribePhoneNumbersRequest.getter(DescribePhoneNumbersRequest::filters)).setter(DescribePhoneNumbersRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhoneNumberFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribePhoneNumbersRequest.getter(DescribePhoneNumbersRequest::nextToken)).setter(DescribePhoneNumbersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribePhoneNumbersRequest.getter(DescribePhoneNumbersRequest::maxResults)).setter(DescribePhoneNumbersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(DescribePhoneNumbersRequest.getter(DescribePhoneNumbersRequest::ownerAsString)).setter(DescribePhoneNumbersRequest.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_IDS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, OWNER_FIELD));
    private final List<String> phoneNumberIds;
    private final List<PhoneNumberFilter> filters;
    private final String nextToken;
    private final Integer maxResults;
    private final String owner;

    private DescribePhoneNumbersRequest(BuilderImpl builder) {
        super(builder);
        this.phoneNumberIds = builder.phoneNumberIds;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.owner = builder.owner;
    }

    public final boolean hasPhoneNumberIds() {
        return this.phoneNumberIds != null && !(this.phoneNumberIds instanceof SdkAutoConstructList);
    }

    public final List<String> phoneNumberIds() {
        return this.phoneNumberIds;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<PhoneNumberFilter> filters() {
        return this.filters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Owner owner() {
        return Owner.fromValue(this.owner);
    }

    public final String ownerAsString() {
        return this.owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhoneNumberIds() ? this.phoneNumberIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePhoneNumbersRequest)) {
            return false;
        }
        DescribePhoneNumbersRequest other = (DescribePhoneNumbersRequest)((Object)obj);
        return this.hasPhoneNumberIds() == other.hasPhoneNumberIds() && Objects.equals(this.phoneNumberIds(), other.phoneNumberIds()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.ownerAsString(), other.ownerAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePhoneNumbersRequest").add("PhoneNumberIds", this.hasPhoneNumberIds() ? this.phoneNumberIds() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Owner", (Object)this.ownerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumberIds": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberIds()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.ownerAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePhoneNumbersRequest, T> g) {
        return obj -> g.apply((DescribePhoneNumbersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private List<String> phoneNumberIds = DefaultSdkAutoConstructList.getInstance();
        private List<PhoneNumberFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;
        private String owner;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePhoneNumbersRequest model) {
            super(model);
            this.phoneNumberIds(model.phoneNumberIds);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.owner(model.owner);
        }

        public final Collection<String> getPhoneNumberIds() {
            if (this.phoneNumberIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.phoneNumberIds;
        }

        public final void setPhoneNumberIds(Collection<String> phoneNumberIds) {
            this.phoneNumberIds = PhoneNumberIdListCopier.copy(phoneNumberIds);
        }

        @Override
        public final Builder phoneNumberIds(Collection<String> phoneNumberIds) {
            this.phoneNumberIds = PhoneNumberIdListCopier.copy(phoneNumberIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberIds(String ... phoneNumberIds) {
            this.phoneNumberIds(Arrays.asList(phoneNumberIds));
            return this;
        }

        public final List<PhoneNumberFilter.Builder> getFilters() {
            List<PhoneNumberFilter.Builder> result = PhoneNumberFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<PhoneNumberFilter.BuilderImpl> filters) {
            this.filters = PhoneNumberFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<PhoneNumberFilter> filters) {
            this.filters = PhoneNumberFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(PhoneNumberFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<PhoneNumberFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (PhoneNumberFilter)((PhoneNumberFilter.Builder)PhoneNumberFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner(owner == null ? null : owner.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePhoneNumbersRequest build() {
            return new DescribePhoneNumbersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePhoneNumbersRequest> {
        public Builder phoneNumberIds(Collection<String> var1);

        public Builder phoneNumberIds(String ... var1);

        public Builder filters(Collection<PhoneNumberFilter> var1);

        public Builder filters(PhoneNumberFilter ... var1);

        public Builder filters(Consumer<PhoneNumberFilter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder owner(String var1);

        public Builder owner(Owner var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

