/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AccountAttribute;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse;

public class DescribeAccountAttributesIterable
implements SdkIterable<DescribeAccountAttributesResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final DescribeAccountAttributesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAccountAttributesIterable(PinpointSmsVoiceV2Client client, DescribeAccountAttributesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeAccountAttributesResponseFetcher();
    }

    public Iterator<DescribeAccountAttributesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountAttribute> accountAttributes() {
        Function<DescribeAccountAttributesResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountAttributes() != null) {
                return response.accountAttributes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAccountAttributesResponseFetcher
    implements SyncPageFetcher<DescribeAccountAttributesResponse> {
        private DescribeAccountAttributesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAccountAttributesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAccountAttributesResponse nextPage(DescribeAccountAttributesResponse previousPage) {
            if (previousPage == null) {
                return DescribeAccountAttributesIterable.this.client.describeAccountAttributes(DescribeAccountAttributesIterable.this.firstRequest);
            }
            return DescribeAccountAttributesIterable.this.client.describeAccountAttributes((DescribeAccountAttributesRequest)((Object)DescribeAccountAttributesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

