/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationFieldValueInformation;

public class DescribeRegistrationFieldValuesIterable
implements SdkIterable<DescribeRegistrationFieldValuesResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final DescribeRegistrationFieldValuesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRegistrationFieldValuesIterable(PinpointSmsVoiceV2Client client, DescribeRegistrationFieldValuesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeRegistrationFieldValuesResponseFetcher();
    }

    public Iterator<DescribeRegistrationFieldValuesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RegistrationFieldValueInformation> registrationFieldValues() {
        Function<DescribeRegistrationFieldValuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.registrationFieldValues() != null) {
                return response.registrationFieldValues().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRegistrationFieldValuesResponseFetcher
    implements SyncPageFetcher<DescribeRegistrationFieldValuesResponse> {
        private DescribeRegistrationFieldValuesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRegistrationFieldValuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRegistrationFieldValuesResponse nextPage(DescribeRegistrationFieldValuesResponse previousPage) {
            if (previousPage == null) {
                return DescribeRegistrationFieldValuesIterable.this.client.describeRegistrationFieldValues(DescribeRegistrationFieldValuesIterable.this.firstRequest);
            }
            return DescribeRegistrationFieldValuesIterable.this.client.describeRegistrationFieldValues((DescribeRegistrationFieldValuesRequest)((Object)DescribeRegistrationFieldValuesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

