/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifiedDestinationNumberInformation;

public class DescribeVerifiedDestinationNumbersIterable
implements SdkIterable<DescribeVerifiedDestinationNumbersResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final DescribeVerifiedDestinationNumbersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVerifiedDestinationNumbersIterable(PinpointSmsVoiceV2Client client, DescribeVerifiedDestinationNumbersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeVerifiedDestinationNumbersResponseFetcher();
    }

    public Iterator<DescribeVerifiedDestinationNumbersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VerifiedDestinationNumberInformation> verifiedDestinationNumbers() {
        Function<DescribeVerifiedDestinationNumbersResponse, Iterator> getIterator = response -> {
            if (response != null && response.verifiedDestinationNumbers() != null) {
                return response.verifiedDestinationNumbers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeVerifiedDestinationNumbersResponseFetcher
    implements SyncPageFetcher<DescribeVerifiedDestinationNumbersResponse> {
        private DescribeVerifiedDestinationNumbersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVerifiedDestinationNumbersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeVerifiedDestinationNumbersResponse nextPage(DescribeVerifiedDestinationNumbersResponse previousPage) {
            if (previousPage == null) {
                return DescribeVerifiedDestinationNumbersIterable.this.client.describeVerifiedDestinationNumbers(DescribeVerifiedDestinationNumbersIterable.this.firstRequest);
            }
            return DescribeVerifiedDestinationNumbersIterable.this.client.describeVerifiedDestinationNumbers((DescribeVerifiedDestinationNumbersRequest)((Object)DescribeVerifiedDestinationNumbersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

