/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationVersionInformation;

public class DescribeRegistrationVersionsIterable
implements SdkIterable<DescribeRegistrationVersionsResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final DescribeRegistrationVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRegistrationVersionsIterable(PinpointSmsVoiceV2Client client, DescribeRegistrationVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeRegistrationVersionsResponseFetcher();
    }

    public Iterator<DescribeRegistrationVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RegistrationVersionInformation> registrationVersions() {
        Function<DescribeRegistrationVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.registrationVersions() != null) {
                return response.registrationVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRegistrationVersionsResponseFetcher
    implements SyncPageFetcher<DescribeRegistrationVersionsResponse> {
        private DescribeRegistrationVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRegistrationVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRegistrationVersionsResponse nextPage(DescribeRegistrationVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRegistrationVersionsIterable.this.client.describeRegistrationVersions(DescribeRegistrationVersionsIterable.this.firstRequest);
            }
            return DescribeRegistrationVersionsIterable.this.client.describeRegistrationVersions((DescribeRegistrationVersionsRequest)((Object)DescribeRegistrationVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

