/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationStatus;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.StringMapCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRegistrationResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, CreateRegistrationResponse> {
    private static final SdkField<String> REGISTRATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationArn").getter(CreateRegistrationResponse.getter(CreateRegistrationResponse::registrationArn)).setter(CreateRegistrationResponse.setter(Builder::registrationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationArn").build()}).build();
    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationId").getter(CreateRegistrationResponse.getter(CreateRegistrationResponse::registrationId)).setter(CreateRegistrationResponse.setter(Builder::registrationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationId").build()}).build();
    private static final SdkField<String> REGISTRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationType").getter(CreateRegistrationResponse.getter(CreateRegistrationResponse::registrationType)).setter(CreateRegistrationResponse.setter(Builder::registrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationType").build()}).build();
    private static final SdkField<String> REGISTRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationStatus").getter(CreateRegistrationResponse.getter(CreateRegistrationResponse::registrationStatusAsString)).setter(CreateRegistrationResponse.setter(Builder::registrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationStatus").build()}).build();
    private static final SdkField<Long> CURRENT_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CurrentVersionNumber").getter(CreateRegistrationResponse.getter(CreateRegistrationResponse::currentVersionNumber)).setter(CreateRegistrationResponse.setter(Builder::currentVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersionNumber").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalAttributes").getter(CreateRegistrationResponse.getter(CreateRegistrationResponse::additionalAttributes)).setter(CreateRegistrationResponse.setter(Builder::additionalAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateRegistrationResponse.getter(CreateRegistrationResponse::tags)).setter(CreateRegistrationResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(CreateRegistrationResponse.getter(CreateRegistrationResponse::createdTimestamp)).setter(CreateRegistrationResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_ARN_FIELD, REGISTRATION_ID_FIELD, REGISTRATION_TYPE_FIELD, REGISTRATION_STATUS_FIELD, CURRENT_VERSION_NUMBER_FIELD, ADDITIONAL_ATTRIBUTES_FIELD, TAGS_FIELD, CREATED_TIMESTAMP_FIELD));
    private final String registrationArn;
    private final String registrationId;
    private final String registrationType;
    private final String registrationStatus;
    private final Long currentVersionNumber;
    private final Map<String, String> additionalAttributes;
    private final List<Tag> tags;
    private final Instant createdTimestamp;

    private CreateRegistrationResponse(BuilderImpl builder) {
        super(builder);
        this.registrationArn = builder.registrationArn;
        this.registrationId = builder.registrationId;
        this.registrationType = builder.registrationType;
        this.registrationStatus = builder.registrationStatus;
        this.currentVersionNumber = builder.currentVersionNumber;
        this.additionalAttributes = builder.additionalAttributes;
        this.tags = builder.tags;
        this.createdTimestamp = builder.createdTimestamp;
    }

    public final String registrationArn() {
        return this.registrationArn;
    }

    public final String registrationId() {
        return this.registrationId;
    }

    public final String registrationType() {
        return this.registrationType;
    }

    public final RegistrationStatus registrationStatus() {
        return RegistrationStatus.fromValue(this.registrationStatus);
    }

    public final String registrationStatusAsString() {
        return this.registrationStatus;
    }

    public final Long currentVersionNumber() {
        return this.currentVersionNumber;
    }

    public final boolean hasAdditionalAttributes() {
        return this.additionalAttributes != null && !(this.additionalAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalAttributes() {
        return this.additionalAttributes;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalAttributes() ? this.additionalAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRegistrationResponse)) {
            return false;
        }
        CreateRegistrationResponse other = (CreateRegistrationResponse)((Object)obj);
        return Objects.equals(this.registrationArn(), other.registrationArn()) && Objects.equals(this.registrationId(), other.registrationId()) && Objects.equals(this.registrationType(), other.registrationType()) && Objects.equals(this.registrationStatusAsString(), other.registrationStatusAsString()) && Objects.equals(this.currentVersionNumber(), other.currentVersionNumber()) && this.hasAdditionalAttributes() == other.hasAdditionalAttributes() && Objects.equals(this.additionalAttributes(), other.additionalAttributes()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRegistrationResponse").add("RegistrationArn", (Object)this.registrationArn()).add("RegistrationId", (Object)this.registrationId()).add("RegistrationType", (Object)this.registrationType()).add("RegistrationStatus", (Object)this.registrationStatusAsString()).add("CurrentVersionNumber", (Object)this.currentVersionNumber()).add("AdditionalAttributes", this.hasAdditionalAttributes() ? this.additionalAttributes() : null).add("Tags", this.hasTags() ? this.tags() : null).add("CreatedTimestamp", (Object)this.createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistrationArn": {
                return Optional.ofNullable(clazz.cast(this.registrationArn()));
            }
            case "RegistrationId": {
                return Optional.ofNullable(clazz.cast(this.registrationId()));
            }
            case "RegistrationType": {
                return Optional.ofNullable(clazz.cast(this.registrationType()));
            }
            case "RegistrationStatus": {
                return Optional.ofNullable(clazz.cast(this.registrationStatusAsString()));
            }
            case "CurrentVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.currentVersionNumber()));
            }
            case "AdditionalAttributes": {
                return Optional.ofNullable(clazz.cast(this.additionalAttributes()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRegistrationResponse, T> g) {
        return obj -> g.apply((CreateRegistrationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private String registrationArn;
        private String registrationId;
        private String registrationType;
        private String registrationStatus;
        private Long currentVersionNumber;
        private Map<String, String> additionalAttributes = DefaultSdkAutoConstructMap.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRegistrationResponse model) {
            super(model);
            this.registrationArn(model.registrationArn);
            this.registrationId(model.registrationId);
            this.registrationType(model.registrationType);
            this.registrationStatus(model.registrationStatus);
            this.currentVersionNumber(model.currentVersionNumber);
            this.additionalAttributes(model.additionalAttributes);
            this.tags(model.tags);
            this.createdTimestamp(model.createdTimestamp);
        }

        public final String getRegistrationArn() {
            return this.registrationArn;
        }

        public final void setRegistrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
        }

        @Override
        public final Builder registrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
            return this;
        }

        public final String getRegistrationId() {
            return this.registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final String getRegistrationType() {
            return this.registrationType;
        }

        public final void setRegistrationType(String registrationType) {
            this.registrationType = registrationType;
        }

        @Override
        public final Builder registrationType(String registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        public final String getRegistrationStatus() {
            return this.registrationStatus;
        }

        public final void setRegistrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
        }

        @Override
        public final Builder registrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
            return this;
        }

        @Override
        public final Builder registrationStatus(RegistrationStatus registrationStatus) {
            this.registrationStatus(registrationStatus == null ? null : registrationStatus.toString());
            return this;
        }

        public final Long getCurrentVersionNumber() {
            return this.currentVersionNumber;
        }

        public final void setCurrentVersionNumber(Long currentVersionNumber) {
            this.currentVersionNumber = currentVersionNumber;
        }

        @Override
        public final Builder currentVersionNumber(Long currentVersionNumber) {
            this.currentVersionNumber = currentVersionNumber;
            return this;
        }

        public final Map<String, String> getAdditionalAttributes() {
            if (this.additionalAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalAttributes;
        }

        public final void setAdditionalAttributes(Map<String, String> additionalAttributes) {
            this.additionalAttributes = StringMapCopier.copy(additionalAttributes);
        }

        @Override
        public final Builder additionalAttributes(Map<String, String> additionalAttributes) {
            this.additionalAttributes = StringMapCopier.copy(additionalAttributes);
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public CreateRegistrationResponse build() {
            return new CreateRegistrationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRegistrationResponse> {
        public Builder registrationArn(String var1);

        public Builder registrationId(String var1);

        public Builder registrationType(String var1);

        public Builder registrationStatus(String var1);

        public Builder registrationStatus(RegistrationStatus var1);

        public Builder currentVersionNumber(Long var1);

        public Builder additionalAttributes(Map<String, String> var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder createdTimestamp(Instant var1);
    }
}

