/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum EventType {
    ALL("ALL"),

    TEXT_ALL("TEXT_ALL"),

    TEXT_SENT("TEXT_SENT"),

    TEXT_PENDING("TEXT_PENDING"),

    TEXT_QUEUED("TEXT_QUEUED"),

    TEXT_SUCCESSFUL("TEXT_SUCCESSFUL"),

    TEXT_DELIVERED("TEXT_DELIVERED"),

    TEXT_INVALID("TEXT_INVALID"),

    TEXT_INVALID_MESSAGE("TEXT_INVALID_MESSAGE"),

    TEXT_UNREACHABLE("TEXT_UNREACHABLE"),

    TEXT_CARRIER_UNREACHABLE("TEXT_CARRIER_UNREACHABLE"),

    TEXT_BLOCKED("TEXT_BLOCKED"),

    TEXT_CARRIER_BLOCKED("TEXT_CARRIER_BLOCKED"),

    TEXT_SPAM("TEXT_SPAM"),

    TEXT_UNKNOWN("TEXT_UNKNOWN"),

    TEXT_TTL_EXPIRED("TEXT_TTL_EXPIRED"),

    VOICE_ALL("VOICE_ALL"),

    VOICE_INITIATED("VOICE_INITIATED"),

    VOICE_RINGING("VOICE_RINGING"),

    VOICE_ANSWERED("VOICE_ANSWERED"),

    VOICE_COMPLETED("VOICE_COMPLETED"),

    VOICE_BUSY("VOICE_BUSY"),

    VOICE_NO_ANSWER("VOICE_NO_ANSWER"),

    VOICE_FAILED("VOICE_FAILED"),

    VOICE_TTL_EXPIRED("VOICE_TTL_EXPIRED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventType> VALUE_MAP = EnumUtils.uniqueIndex(EventType.class, EventType::toString);

    private final String value;

    private EventType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return EventType corresponding to the value
     */
    public static EventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link EventType}s
     */
    public static Set<EventType> knownValues() {
        Set<EventType> knownValues = EnumSet.allOf(EventType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
