/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NumberStatus {
    PENDING("PENDING"),
    ACTIVE("ACTIVE"),
    ASSOCIATING("ASSOCIATING"),
    DISASSOCIATING("DISASSOCIATING"),
    DELETED("DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NumberStatus> VALUE_MAP;
    private final String value;

    private NumberStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NumberStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NumberStatus> knownValues() {
        EnumSet<NumberStatus> knownValues = EnumSet.allOf(NumberStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NumberStatus.class, NumberStatus::toString);
    }
}

