/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisFirehoseDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisFirehoseDestination> {
    private static final SdkField<String> DELIVERY_STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryStreamArn").getter(KinesisFirehoseDestination.getter(KinesisFirehoseDestination::deliveryStreamArn)).setter(KinesisFirehoseDestination.setter(Builder::deliveryStreamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamArn").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(KinesisFirehoseDestination.getter(KinesisFirehoseDestination::iamRoleArn)).setter(KinesisFirehoseDestination.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_ARN_FIELD, IAM_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KinesisFirehoseDestination.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String deliveryStreamArn;
    private final String iamRoleArn;

    private KinesisFirehoseDestination(BuilderImpl builder) {
        this.deliveryStreamArn = builder.deliveryStreamArn;
        this.iamRoleArn = builder.iamRoleArn;
    }

    public final String deliveryStreamArn() {
        return this.deliveryStreamArn;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisFirehoseDestination)) {
            return false;
        }
        KinesisFirehoseDestination other = (KinesisFirehoseDestination)obj;
        return Objects.equals(this.deliveryStreamArn(), other.deliveryStreamArn()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"KinesisFirehoseDestination").add("DeliveryStreamArn", (Object)this.deliveryStreamArn()).add("IamRoleArn", (Object)this.iamRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryStreamArn": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamArn()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DeliveryStreamArn", DELIVERY_STREAM_ARN_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KinesisFirehoseDestination, T> g) {
        return obj -> g.apply((KinesisFirehoseDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deliveryStreamArn;
        private String iamRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisFirehoseDestination model) {
            this.deliveryStreamArn(model.deliveryStreamArn);
            this.iamRoleArn(model.iamRoleArn);
        }

        public final String getDeliveryStreamArn() {
            return this.deliveryStreamArn;
        }

        public final void setDeliveryStreamArn(String deliveryStreamArn) {
            this.deliveryStreamArn = deliveryStreamArn;
        }

        @Override
        public final Builder deliveryStreamArn(String deliveryStreamArn) {
            this.deliveryStreamArn = deliveryStreamArn;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public KinesisFirehoseDestination build() {
            return new KinesisFirehoseDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisFirehoseDestination> {
        public Builder deliveryStreamArn(String var1);

        public Builder iamRoleArn(String var1);
    }
}

