/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoice.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EventType {
    INITIATED_CALL("INITIATED_CALL"),
    RINGING("RINGING"),
    ANSWERED("ANSWERED"),
    COMPLETED_CALL("COMPLETED_CALL"),
    BUSY("BUSY"),
    FAILED("FAILED"),
    NO_ANSWER("NO_ANSWER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EventType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventType> knownValues() {
        return Stream.of(EventType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

