/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.pinpointemail.model.DomainIspPlacement;
import software.amazon.awssdk.services.pinpointemail.model.DomainIspPlacementsCopier;
import software.amazon.awssdk.services.pinpointemail.model.VolumeStatistics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DailyVolume
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DailyVolume> {
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DailyVolume.getter(DailyVolume::startDate)).setter(DailyVolume.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()}).build();
    private static final SdkField<VolumeStatistics> VOLUME_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DailyVolume.getter(DailyVolume::volumeStatistics)).setter(DailyVolume.setter(Builder::volumeStatistics)).constructor(VolumeStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeStatistics").build()}).build();
    private static final SdkField<List<DomainIspPlacement>> DOMAIN_ISP_PLACEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DailyVolume.getter(DailyVolume::domainIspPlacements)).setter(DailyVolume.setter(Builder::domainIspPlacements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIspPlacements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainIspPlacement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_DATE_FIELD, VOLUME_STATISTICS_FIELD, DOMAIN_ISP_PLACEMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant startDate;
    private final VolumeStatistics volumeStatistics;
    private final List<DomainIspPlacement> domainIspPlacements;

    private DailyVolume(BuilderImpl builder) {
        this.startDate = builder.startDate;
        this.volumeStatistics = builder.volumeStatistics;
        this.domainIspPlacements = builder.domainIspPlacements;
    }

    public Instant startDate() {
        return this.startDate;
    }

    public VolumeStatistics volumeStatistics() {
        return this.volumeStatistics;
    }

    public List<DomainIspPlacement> domainIspPlacements() {
        return this.domainIspPlacements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIspPlacements());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DailyVolume)) {
            return false;
        }
        DailyVolume other = (DailyVolume)obj;
        return Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.volumeStatistics(), other.volumeStatistics()) && Objects.equals(this.domainIspPlacements(), other.domainIspPlacements());
    }

    public String toString() {
        return ToString.builder((String)"DailyVolume").add("StartDate", (Object)this.startDate()).add("VolumeStatistics", (Object)this.volumeStatistics()).add("DomainIspPlacements", this.domainIspPlacements()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "VolumeStatistics": {
                return Optional.ofNullable(clazz.cast(this.volumeStatistics()));
            }
            case "DomainIspPlacements": {
                return Optional.ofNullable(clazz.cast(this.domainIspPlacements()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DailyVolume, T> g) {
        return obj -> g.apply((DailyVolume)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant startDate;
        private VolumeStatistics volumeStatistics;
        private List<DomainIspPlacement> domainIspPlacements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DailyVolume model) {
            this.startDate(model.startDate);
            this.volumeStatistics(model.volumeStatistics);
            this.domainIspPlacements(model.domainIspPlacements);
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        public final VolumeStatistics.Builder getVolumeStatistics() {
            return this.volumeStatistics != null ? this.volumeStatistics.toBuilder() : null;
        }

        @Override
        public final Builder volumeStatistics(VolumeStatistics volumeStatistics) {
            this.volumeStatistics = volumeStatistics;
            return this;
        }

        public final void setVolumeStatistics(VolumeStatistics.BuilderImpl volumeStatistics) {
            this.volumeStatistics = volumeStatistics != null ? volumeStatistics.build() : null;
        }

        public final Collection<DomainIspPlacement.Builder> getDomainIspPlacements() {
            return this.domainIspPlacements != null ? (Collection)this.domainIspPlacements.stream().map(DomainIspPlacement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainIspPlacements(Collection<DomainIspPlacement> domainIspPlacements) {
            this.domainIspPlacements = DomainIspPlacementsCopier.copy(domainIspPlacements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainIspPlacements(DomainIspPlacement ... domainIspPlacements) {
            this.domainIspPlacements(Arrays.asList(domainIspPlacements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainIspPlacements(Consumer<DomainIspPlacement.Builder> ... domainIspPlacements) {
            this.domainIspPlacements(Stream.of(domainIspPlacements).map(c -> (DomainIspPlacement)((DomainIspPlacement.Builder)DomainIspPlacement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainIspPlacements(Collection<DomainIspPlacement.BuilderImpl> domainIspPlacements) {
            this.domainIspPlacements = DomainIspPlacementsCopier.copyFromBuilder(domainIspPlacements);
        }

        public DailyVolume build() {
            return new DailyVolume(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DailyVolume> {
        public Builder startDate(Instant var1);

        public Builder volumeStatistics(VolumeStatistics var1);

        default public Builder volumeStatistics(Consumer<VolumeStatistics.Builder> volumeStatistics) {
            return this.volumeStatistics((VolumeStatistics)((VolumeStatistics.Builder)VolumeStatistics.builder().applyMutation(volumeStatistics)).build());
        }

        public Builder domainIspPlacements(Collection<DomainIspPlacement> var1);

        public Builder domainIspPlacements(DomainIspPlacement ... var1);

        public Builder domainIspPlacements(Consumer<DomainIspPlacement.Builder> ... var1);
    }
}

