/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutConfigurationSetTrackingOptionsRequest
extends PinpointEmailRequest
implements ToCopyableBuilder<Builder, PutConfigurationSetTrackingOptionsRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutConfigurationSetTrackingOptionsRequest.getter(PutConfigurationSetTrackingOptionsRequest::configurationSetName)).setter(PutConfigurationSetTrackingOptionsRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationSetName").build()}).build();
    private static final SdkField<String> CUSTOM_REDIRECT_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutConfigurationSetTrackingOptionsRequest.getter(PutConfigurationSetTrackingOptionsRequest::customRedirectDomain)).setter(PutConfigurationSetTrackingOptionsRequest.setter(Builder::customRedirectDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomRedirectDomain").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD, CUSTOM_REDIRECT_DOMAIN_FIELD));
    private final String configurationSetName;
    private final String customRedirectDomain;

    private PutConfigurationSetTrackingOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.customRedirectDomain = builder.customRedirectDomain;
    }

    public String configurationSetName() {
        return this.configurationSetName;
    }

    public String customRedirectDomain() {
        return this.customRedirectDomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.customRedirectDomain());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigurationSetTrackingOptionsRequest)) {
            return false;
        }
        PutConfigurationSetTrackingOptionsRequest other = (PutConfigurationSetTrackingOptionsRequest)((Object)obj);
        return Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.customRedirectDomain(), other.customRedirectDomain());
    }

    public String toString() {
        return ToString.builder((String)"PutConfigurationSetTrackingOptionsRequest").add("ConfigurationSetName", (Object)this.configurationSetName()).add("CustomRedirectDomain", (Object)this.customRedirectDomain()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "CustomRedirectDomain": {
                return Optional.ofNullable(clazz.cast(this.customRedirectDomain()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutConfigurationSetTrackingOptionsRequest, T> g) {
        return obj -> g.apply((PutConfigurationSetTrackingOptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailRequest.BuilderImpl
    implements Builder {
        private String configurationSetName;
        private String customRedirectDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigurationSetTrackingOptionsRequest model) {
            super(model);
            this.configurationSetName(model.configurationSetName);
            this.customRedirectDomain(model.customRedirectDomain);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final String getCustomRedirectDomain() {
            return this.customRedirectDomain;
        }

        @Override
        public final Builder customRedirectDomain(String customRedirectDomain) {
            this.customRedirectDomain = customRedirectDomain;
            return this;
        }

        public final void setCustomRedirectDomain(String customRedirectDomain) {
            this.customRedirectDomain = customRedirectDomain;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfigurationSetTrackingOptionsRequest build() {
            return new PutConfigurationSetTrackingOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointEmailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutConfigurationSetTrackingOptionsRequest> {
        public Builder configurationSetName(String var1);

        public Builder customRedirectDomain(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

