/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointemail.PinpointEmailAsyncClient;
import software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsResponse;

public class ListDedicatedIpPoolsPublisher
implements SdkPublisher<ListDedicatedIpPoolsResponse> {
    private final PinpointEmailAsyncClient client;
    private final ListDedicatedIpPoolsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDedicatedIpPoolsPublisher(PinpointEmailAsyncClient client, ListDedicatedIpPoolsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDedicatedIpPoolsPublisher(PinpointEmailAsyncClient client, ListDedicatedIpPoolsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDedicatedIpPoolsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDedicatedIpPoolsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListDedicatedIpPoolsPublisher resume(ListDedicatedIpPoolsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListDedicatedIpPoolsPublisher(this.client, (ListDedicatedIpPoolsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListDedicatedIpPoolsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListDedicatedIpPoolsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListDedicatedIpPoolsResponseFetcher
    implements AsyncPageFetcher<ListDedicatedIpPoolsResponse> {
        private ListDedicatedIpPoolsResponseFetcher() {
        }

        public boolean hasNextPage(ListDedicatedIpPoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDedicatedIpPoolsResponse> nextPage(ListDedicatedIpPoolsResponse previousPage) {
            if (previousPage == null) {
                return ListDedicatedIpPoolsPublisher.this.client.listDedicatedIpPools(ListDedicatedIpPoolsPublisher.this.firstRequest);
            }
            return ListDedicatedIpPoolsPublisher.this.client.listDedicatedIpPools((ListDedicatedIpPoolsRequest)((Object)ListDedicatedIpPoolsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

