/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointemail.model.DkimStatus;
import software.amazon.awssdk.services.pinpointemail.model.DnsTokenListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DkimAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DkimAttributes> {
    private static final SdkField<Boolean> SIGNING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SigningEnabled").getter(DkimAttributes.getter(DkimAttributes::signingEnabled)).setter(DkimAttributes.setter(Builder::signingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningEnabled").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DkimAttributes.getter(DkimAttributes::statusAsString)).setter(DkimAttributes.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tokens").getter(DkimAttributes.getter(DkimAttributes::tokens)).setter(DkimAttributes.setter(Builder::tokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNING_ENABLED_FIELD, STATUS_FIELD, TOKENS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DkimAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean signingEnabled;
    private final String status;
    private final List<String> tokens;

    private DkimAttributes(BuilderImpl builder) {
        this.signingEnabled = builder.signingEnabled;
        this.status = builder.status;
        this.tokens = builder.tokens;
    }

    public final Boolean signingEnabled() {
        return this.signingEnabled;
    }

    public final DkimStatus status() {
        return DkimStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTokens() {
        return this.tokens != null && !(this.tokens instanceof SdkAutoConstructList);
    }

    public final List<String> tokens() {
        return this.tokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.signingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTokens() ? this.tokens() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DkimAttributes)) {
            return false;
        }
        DkimAttributes other = (DkimAttributes)obj;
        return Objects.equals(this.signingEnabled(), other.signingEnabled()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTokens() == other.hasTokens() && Objects.equals(this.tokens(), other.tokens());
    }

    public final String toString() {
        return ToString.builder((String)"DkimAttributes").add("SigningEnabled", (Object)this.signingEnabled()).add("Status", (Object)this.statusAsString()).add("Tokens", this.hasTokens() ? this.tokens() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SigningEnabled": {
                return Optional.ofNullable(clazz.cast(this.signingEnabled()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Tokens": {
                return Optional.ofNullable(clazz.cast(this.tokens()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SigningEnabled", SIGNING_ENABLED_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Tokens", TOKENS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DkimAttributes, T> g) {
        return obj -> g.apply((DkimAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean signingEnabled;
        private String status;
        private List<String> tokens = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DkimAttributes model) {
            this.signingEnabled(model.signingEnabled);
            this.status(model.status);
            this.tokens(model.tokens);
        }

        public final Boolean getSigningEnabled() {
            return this.signingEnabled;
        }

        public final void setSigningEnabled(Boolean signingEnabled) {
            this.signingEnabled = signingEnabled;
        }

        @Override
        public final Builder signingEnabled(Boolean signingEnabled) {
            this.signingEnabled = signingEnabled;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DkimStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getTokens() {
            if (this.tokens instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tokens;
        }

        public final void setTokens(Collection<String> tokens) {
            this.tokens = DnsTokenListCopier.copy(tokens);
        }

        @Override
        public final Builder tokens(Collection<String> tokens) {
            this.tokens = DnsTokenListCopier.copy(tokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokens(String ... tokens) {
            this.tokens(Arrays.asList(tokens));
            return this;
        }

        public DkimAttributes build() {
            return new DkimAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DkimAttributes> {
        public Builder signingEnabled(Boolean var1);

        public Builder status(String var1);

        public Builder status(DkimStatus var1);

        public Builder tokens(Collection<String> var1);

        public Builder tokens(String ... var1);
    }
}

