/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointemail.model.Content;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Body
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Body> {
    private static final SdkField<Content> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Text").getter(Body.getter(Body::text)).setter(Body.setter(Builder::text)).constructor(Content::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<Content> HTML_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Html").getter(Body.getter(Body::html)).setter(Body.setter(Builder::html)).constructor(Content::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Html").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, HTML_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Text", TEXT_FIELD);
            this.put("Html", HTML_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Content text;
    private final Content html;

    private Body(BuilderImpl builder) {
        this.text = builder.text;
        this.html = builder.html;
    }

    public final Content text() {
        return this.text;
    }

    public final Content html() {
        return this.html;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.html());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Body)) {
            return false;
        }
        Body other = (Body)obj;
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.html(), other.html());
    }

    public final String toString() {
        return ToString.builder((String)"Body").add("Text", (Object)this.text()).add("Html", (Object)this.html()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "Html": {
                return Optional.ofNullable(clazz.cast(this.html()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Body, T> g) {
        return obj -> g.apply((Body)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Content text;
        private Content html;

        private BuilderImpl() {
        }

        private BuilderImpl(Body model) {
            this.text(model.text);
            this.html(model.html);
        }

        public final Content.Builder getText() {
            return this.text != null ? this.text.toBuilder() : null;
        }

        public final void setText(Content.BuilderImpl text) {
            this.text = text != null ? text.build() : null;
        }

        @Override
        public final Builder text(Content text) {
            this.text = text;
            return this;
        }

        public final Content.Builder getHtml() {
            return this.html != null ? this.html.toBuilder() : null;
        }

        public final void setHtml(Content.BuilderImpl html) {
            this.html = html != null ? html.build() : null;
        }

        @Override
        public final Builder html(Content html) {
            this.html = html;
            return this;
        }

        public Body build() {
            return new Body(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Body> {
        public Builder text(Content var1);

        default public Builder text(Consumer<Content.Builder> text) {
            return this.text((Content)((Content.Builder)Content.builder().applyMutation(text)).build());
        }

        public Builder html(Content var1);

        default public Builder html(Consumer<Content.Builder> html) {
            return this.html((Content)((Content.Builder)Content.builder().applyMutation(html)).build());
        }
    }
}

