/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEmailIdentityFeedbackAttributesRequest
extends PinpointEmailRequest
implements ToCopyableBuilder<Builder, PutEmailIdentityFeedbackAttributesRequest> {
    private static final SdkField<String> EMAIL_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailIdentity").getter(PutEmailIdentityFeedbackAttributesRequest.getter(PutEmailIdentityFeedbackAttributesRequest::emailIdentity)).setter(PutEmailIdentityFeedbackAttributesRequest.setter(Builder::emailIdentity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EmailIdentity").build()}).build();
    private static final SdkField<Boolean> EMAIL_FORWARDING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EmailForwardingEnabled").getter(PutEmailIdentityFeedbackAttributesRequest.getter(PutEmailIdentityFeedbackAttributesRequest::emailForwardingEnabled)).setter(PutEmailIdentityFeedbackAttributesRequest.setter(Builder::emailForwardingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailForwardingEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_IDENTITY_FIELD, EMAIL_FORWARDING_ENABLED_FIELD));
    private final String emailIdentity;
    private final Boolean emailForwardingEnabled;

    private PutEmailIdentityFeedbackAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.emailIdentity = builder.emailIdentity;
        this.emailForwardingEnabled = builder.emailForwardingEnabled;
    }

    public final String emailIdentity() {
        return this.emailIdentity;
    }

    public final Boolean emailForwardingEnabled() {
        return this.emailForwardingEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.emailIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailForwardingEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEmailIdentityFeedbackAttributesRequest)) {
            return false;
        }
        PutEmailIdentityFeedbackAttributesRequest other = (PutEmailIdentityFeedbackAttributesRequest)((Object)obj);
        return Objects.equals(this.emailIdentity(), other.emailIdentity()) && Objects.equals(this.emailForwardingEnabled(), other.emailForwardingEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"PutEmailIdentityFeedbackAttributesRequest").add("EmailIdentity", (Object)this.emailIdentity()).add("EmailForwardingEnabled", (Object)this.emailForwardingEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmailIdentity": {
                return Optional.ofNullable(clazz.cast(this.emailIdentity()));
            }
            case "EmailForwardingEnabled": {
                return Optional.ofNullable(clazz.cast(this.emailForwardingEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEmailIdentityFeedbackAttributesRequest, T> g) {
        return obj -> g.apply((PutEmailIdentityFeedbackAttributesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailRequest.BuilderImpl
    implements Builder {
        private String emailIdentity;
        private Boolean emailForwardingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEmailIdentityFeedbackAttributesRequest model) {
            super(model);
            this.emailIdentity(model.emailIdentity);
            this.emailForwardingEnabled(model.emailForwardingEnabled);
        }

        public final String getEmailIdentity() {
            return this.emailIdentity;
        }

        public final void setEmailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
        }

        @Override
        public final Builder emailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
            return this;
        }

        public final Boolean getEmailForwardingEnabled() {
            return this.emailForwardingEnabled;
        }

        public final void setEmailForwardingEnabled(Boolean emailForwardingEnabled) {
            this.emailForwardingEnabled = emailForwardingEnabled;
        }

        @Override
        public final Builder emailForwardingEnabled(Boolean emailForwardingEnabled) {
            this.emailForwardingEnabled = emailForwardingEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEmailIdentityFeedbackAttributesRequest build() {
            return new PutEmailIdentityFeedbackAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointEmailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutEmailIdentityFeedbackAttributesRequest> {
        public Builder emailIdentity(String var1);

        public Builder emailForwardingEnabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

