/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointemail.model.IspNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InboxPlacementTrackingOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InboxPlacementTrackingOption> {
    private static final SdkField<Boolean> GLOBAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Global").getter(InboxPlacementTrackingOption.getter(InboxPlacementTrackingOption::global)).setter(InboxPlacementTrackingOption.setter(Builder::global)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Global").build()}).build();
    private static final SdkField<List<String>> TRACKED_ISPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrackedIsps").getter(InboxPlacementTrackingOption.getter(InboxPlacementTrackingOption::trackedIsps)).setter(InboxPlacementTrackingOption.setter(Builder::trackedIsps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackedIsps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_FIELD, TRACKED_ISPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean global;
    private final List<String> trackedIsps;

    private InboxPlacementTrackingOption(BuilderImpl builder) {
        this.global = builder.global;
        this.trackedIsps = builder.trackedIsps;
    }

    public final Boolean global() {
        return this.global;
    }

    public final boolean hasTrackedIsps() {
        return this.trackedIsps != null && !(this.trackedIsps instanceof SdkAutoConstructList);
    }

    public final List<String> trackedIsps() {
        return this.trackedIsps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.global());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrackedIsps() ? this.trackedIsps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InboxPlacementTrackingOption)) {
            return false;
        }
        InboxPlacementTrackingOption other = (InboxPlacementTrackingOption)obj;
        return Objects.equals(this.global(), other.global()) && this.hasTrackedIsps() == other.hasTrackedIsps() && Objects.equals(this.trackedIsps(), other.trackedIsps());
    }

    public final String toString() {
        return ToString.builder((String)"InboxPlacementTrackingOption").add("Global", (Object)this.global()).add("TrackedIsps", this.hasTrackedIsps() ? this.trackedIsps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Global": {
                return Optional.ofNullable(clazz.cast(this.global()));
            }
            case "TrackedIsps": {
                return Optional.ofNullable(clazz.cast(this.trackedIsps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InboxPlacementTrackingOption, T> g) {
        return obj -> g.apply((InboxPlacementTrackingOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean global;
        private List<String> trackedIsps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InboxPlacementTrackingOption model) {
            this.global(model.global);
            this.trackedIsps(model.trackedIsps);
        }

        public final Boolean getGlobal() {
            return this.global;
        }

        public final void setGlobal(Boolean global) {
            this.global = global;
        }

        @Override
        @Transient
        public final Builder global(Boolean global) {
            this.global = global;
            return this;
        }

        public final Collection<String> getTrackedIsps() {
            if (this.trackedIsps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.trackedIsps;
        }

        public final void setTrackedIsps(Collection<String> trackedIsps) {
            this.trackedIsps = IspNameListCopier.copy(trackedIsps);
        }

        @Override
        @Transient
        public final Builder trackedIsps(Collection<String> trackedIsps) {
            this.trackedIsps = IspNameListCopier.copy(trackedIsps);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder trackedIsps(String ... trackedIsps) {
            this.trackedIsps(Arrays.asList(trackedIsps));
            return this;
        }

        public InboxPlacementTrackingOption build() {
            return new InboxPlacementTrackingOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InboxPlacementTrackingOption> {
        public Builder global(Boolean var1);

        public Builder trackedIsps(Collection<String> var1);

        public Builder trackedIsps(String ... var1);
    }
}

