/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointemail.model.DeliveryOptions;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailResponse;
import software.amazon.awssdk.services.pinpointemail.model.ReputationOptions;
import software.amazon.awssdk.services.pinpointemail.model.SendingOptions;
import software.amazon.awssdk.services.pinpointemail.model.Tag;
import software.amazon.awssdk.services.pinpointemail.model.TagListCopier;
import software.amazon.awssdk.services.pinpointemail.model.TrackingOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConfigurationSetResponse
extends PinpointEmailResponse
implements ToCopyableBuilder<Builder, GetConfigurationSetResponse> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(GetConfigurationSetResponse.getter(GetConfigurationSetResponse::configurationSetName)).setter(GetConfigurationSetResponse.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build()}).build();
    private static final SdkField<TrackingOptions> TRACKING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrackingOptions").getter(GetConfigurationSetResponse.getter(GetConfigurationSetResponse::trackingOptions)).setter(GetConfigurationSetResponse.setter(Builder::trackingOptions)).constructor(TrackingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingOptions").build()}).build();
    private static final SdkField<DeliveryOptions> DELIVERY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeliveryOptions").getter(GetConfigurationSetResponse.getter(GetConfigurationSetResponse::deliveryOptions)).setter(GetConfigurationSetResponse.setter(Builder::deliveryOptions)).constructor(DeliveryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryOptions").build()}).build();
    private static final SdkField<ReputationOptions> REPUTATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReputationOptions").getter(GetConfigurationSetResponse.getter(GetConfigurationSetResponse::reputationOptions)).setter(GetConfigurationSetResponse.setter(Builder::reputationOptions)).constructor(ReputationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReputationOptions").build()}).build();
    private static final SdkField<SendingOptions> SENDING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SendingOptions").getter(GetConfigurationSetResponse.getter(GetConfigurationSetResponse::sendingOptions)).setter(GetConfigurationSetResponse.setter(Builder::sendingOptions)).constructor(SendingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingOptions").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(GetConfigurationSetResponse.getter(GetConfigurationSetResponse::tags)).setter(GetConfigurationSetResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD, TRACKING_OPTIONS_FIELD, DELIVERY_OPTIONS_FIELD, REPUTATION_OPTIONS_FIELD, SENDING_OPTIONS_FIELD, TAGS_FIELD));
    private final String configurationSetName;
    private final TrackingOptions trackingOptions;
    private final DeliveryOptions deliveryOptions;
    private final ReputationOptions reputationOptions;
    private final SendingOptions sendingOptions;
    private final List<Tag> tags;

    private GetConfigurationSetResponse(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.trackingOptions = builder.trackingOptions;
        this.deliveryOptions = builder.deliveryOptions;
        this.reputationOptions = builder.reputationOptions;
        this.sendingOptions = builder.sendingOptions;
        this.tags = builder.tags;
    }

    public String configurationSetName() {
        return this.configurationSetName;
    }

    public TrackingOptions trackingOptions() {
        return this.trackingOptions;
    }

    public DeliveryOptions deliveryOptions() {
        return this.deliveryOptions;
    }

    public ReputationOptions reputationOptions() {
        return this.reputationOptions;
    }

    public SendingOptions sendingOptions() {
        return this.sendingOptions;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.reputationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.sendingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigurationSetResponse)) {
            return false;
        }
        GetConfigurationSetResponse other = (GetConfigurationSetResponse)((Object)obj);
        return Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.trackingOptions(), other.trackingOptions()) && Objects.equals(this.deliveryOptions(), other.deliveryOptions()) && Objects.equals(this.reputationOptions(), other.reputationOptions()) && Objects.equals(this.sendingOptions(), other.sendingOptions()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"GetConfigurationSetResponse").add("ConfigurationSetName", (Object)this.configurationSetName()).add("TrackingOptions", (Object)this.trackingOptions()).add("DeliveryOptions", (Object)this.deliveryOptions()).add("ReputationOptions", (Object)this.reputationOptions()).add("SendingOptions", (Object)this.sendingOptions()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "TrackingOptions": {
                return Optional.ofNullable(clazz.cast(this.trackingOptions()));
            }
            case "DeliveryOptions": {
                return Optional.ofNullable(clazz.cast(this.deliveryOptions()));
            }
            case "ReputationOptions": {
                return Optional.ofNullable(clazz.cast(this.reputationOptions()));
            }
            case "SendingOptions": {
                return Optional.ofNullable(clazz.cast(this.sendingOptions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfigurationSetResponse, T> g) {
        return obj -> g.apply((GetConfigurationSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailResponse.BuilderImpl
    implements Builder {
        private String configurationSetName;
        private TrackingOptions trackingOptions;
        private DeliveryOptions deliveryOptions;
        private ReputationOptions reputationOptions;
        private SendingOptions sendingOptions;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigurationSetResponse model) {
            super(model);
            this.configurationSetName(model.configurationSetName);
            this.trackingOptions(model.trackingOptions);
            this.deliveryOptions(model.deliveryOptions);
            this.reputationOptions(model.reputationOptions);
            this.sendingOptions(model.sendingOptions);
            this.tags(model.tags);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final TrackingOptions.Builder getTrackingOptions() {
            return this.trackingOptions != null ? this.trackingOptions.toBuilder() : null;
        }

        @Override
        public final Builder trackingOptions(TrackingOptions trackingOptions) {
            this.trackingOptions = trackingOptions;
            return this;
        }

        public final void setTrackingOptions(TrackingOptions.BuilderImpl trackingOptions) {
            this.trackingOptions = trackingOptions != null ? trackingOptions.build() : null;
        }

        public final DeliveryOptions.Builder getDeliveryOptions() {
            return this.deliveryOptions != null ? this.deliveryOptions.toBuilder() : null;
        }

        @Override
        public final Builder deliveryOptions(DeliveryOptions deliveryOptions) {
            this.deliveryOptions = deliveryOptions;
            return this;
        }

        public final void setDeliveryOptions(DeliveryOptions.BuilderImpl deliveryOptions) {
            this.deliveryOptions = deliveryOptions != null ? deliveryOptions.build() : null;
        }

        public final ReputationOptions.Builder getReputationOptions() {
            return this.reputationOptions != null ? this.reputationOptions.toBuilder() : null;
        }

        @Override
        public final Builder reputationOptions(ReputationOptions reputationOptions) {
            this.reputationOptions = reputationOptions;
            return this;
        }

        public final void setReputationOptions(ReputationOptions.BuilderImpl reputationOptions) {
            this.reputationOptions = reputationOptions != null ? reputationOptions.build() : null;
        }

        public final SendingOptions.Builder getSendingOptions() {
            return this.sendingOptions != null ? this.sendingOptions.toBuilder() : null;
        }

        @Override
        public final Builder sendingOptions(SendingOptions sendingOptions) {
            this.sendingOptions = sendingOptions;
            return this;
        }

        public final void setSendingOptions(SendingOptions.BuilderImpl sendingOptions) {
            this.sendingOptions = sendingOptions != null ? sendingOptions.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public GetConfigurationSetResponse build() {
            return new GetConfigurationSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointEmailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConfigurationSetResponse> {
        public Builder configurationSetName(String var1);

        public Builder trackingOptions(TrackingOptions var1);

        default public Builder trackingOptions(Consumer<TrackingOptions.Builder> trackingOptions) {
            return this.trackingOptions((TrackingOptions)((TrackingOptions.Builder)TrackingOptions.builder().applyMutation(trackingOptions)).build());
        }

        public Builder deliveryOptions(DeliveryOptions var1);

        default public Builder deliveryOptions(Consumer<DeliveryOptions.Builder> deliveryOptions) {
            return this.deliveryOptions((DeliveryOptions)((DeliveryOptions.Builder)DeliveryOptions.builder().applyMutation(deliveryOptions)).build());
        }

        public Builder reputationOptions(ReputationOptions var1);

        default public Builder reputationOptions(Consumer<ReputationOptions.Builder> reputationOptions) {
            return this.reputationOptions((ReputationOptions)((ReputationOptions.Builder)ReputationOptions.builder().applyMutation(reputationOptions)).build());
        }

        public Builder sendingOptions(SendingOptions var1);

        default public Builder sendingOptions(Consumer<SendingOptions.Builder> sendingOptions) {
            return this.sendingOptions((SendingOptions)((SendingOptions.Builder)SendingOptions.builder().applyMutation(sendingOptions)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

