/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.pinpointemail.PinpointEmailClient;
import software.amazon.awssdk.services.pinpointemail.model.AccountSuspendedException;
import software.amazon.awssdk.services.pinpointemail.model.AlreadyExistsException;
import software.amazon.awssdk.services.pinpointemail.model.BadRequestException;
import software.amazon.awssdk.services.pinpointemail.model.ConcurrentModificationException;
import software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetRequest;
import software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetResponse;
import software.amazon.awssdk.services.pinpointemail.model.CreateDedicatedIpPoolRequest;
import software.amazon.awssdk.services.pinpointemail.model.CreateDedicatedIpPoolResponse;
import software.amazon.awssdk.services.pinpointemail.model.CreateDeliverabilityTestReportRequest;
import software.amazon.awssdk.services.pinpointemail.model.CreateDeliverabilityTestReportResponse;
import software.amazon.awssdk.services.pinpointemail.model.CreateEmailIdentityRequest;
import software.amazon.awssdk.services.pinpointemail.model.CreateEmailIdentityResponse;
import software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetRequest;
import software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetResponse;
import software.amazon.awssdk.services.pinpointemail.model.DeleteDedicatedIpPoolRequest;
import software.amazon.awssdk.services.pinpointemail.model.DeleteDedicatedIpPoolResponse;
import software.amazon.awssdk.services.pinpointemail.model.DeleteEmailIdentityRequest;
import software.amazon.awssdk.services.pinpointemail.model.DeleteEmailIdentityResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetAccountRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetAccountResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetBlacklistReportsRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetBlacklistReportsResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetEventDestinationsRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetEventDestinationsResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpsRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpsResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityDashboardOptionsRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityTestReportRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityTestReportResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetDomainDeliverabilityCampaignRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetDomainDeliverabilityCampaignResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetDomainStatisticsReportRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetDomainStatisticsReportResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetEmailIdentityRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetEmailIdentityResponse;
import software.amazon.awssdk.services.pinpointemail.model.LimitExceededException;
import software.amazon.awssdk.services.pinpointemail.model.ListConfigurationSetsRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListConfigurationSetsResponse;
import software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsResponse;
import software.amazon.awssdk.services.pinpointemail.model.ListDeliverabilityTestReportsRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListDeliverabilityTestReportsResponse;
import software.amazon.awssdk.services.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse;
import software.amazon.awssdk.services.pinpointemail.model.ListEmailIdentitiesRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListEmailIdentitiesResponse;
import software.amazon.awssdk.services.pinpointemail.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pinpointemail.model.MailFromDomainNotVerifiedException;
import software.amazon.awssdk.services.pinpointemail.model.MessageRejectedException;
import software.amazon.awssdk.services.pinpointemail.model.NotFoundException;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailException;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutAccountSendingAttributesRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutAccountSendingAttributesResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetDeliveryOptionsRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetDeliveryOptionsResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetReputationOptionsRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetReputationOptionsResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetSendingOptionsRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetSendingOptionsResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutDedicatedIpInPoolRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutDedicatedIpInPoolResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutDedicatedIpWarmupAttributesRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutDedicatedIpWarmupAttributesResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutDeliverabilityDashboardOptionRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutDeliverabilityDashboardOptionResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityDkimAttributesRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityDkimAttributesResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityFeedbackAttributesRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityFeedbackAttributesResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityMailFromAttributesRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityMailFromAttributesResponse;
import software.amazon.awssdk.services.pinpointemail.model.SendEmailRequest;
import software.amazon.awssdk.services.pinpointemail.model.SendEmailResponse;
import software.amazon.awssdk.services.pinpointemail.model.SendingPausedException;
import software.amazon.awssdk.services.pinpointemail.model.TagResourceRequest;
import software.amazon.awssdk.services.pinpointemail.model.TagResourceResponse;
import software.amazon.awssdk.services.pinpointemail.model.TooManyRequestsException;
import software.amazon.awssdk.services.pinpointemail.model.UntagResourceRequest;
import software.amazon.awssdk.services.pinpointemail.model.UntagResourceResponse;
import software.amazon.awssdk.services.pinpointemail.model.UpdateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.pinpointemail.model.UpdateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.pinpointemail.paginators.GetDedicatedIpsIterable;
import software.amazon.awssdk.services.pinpointemail.paginators.ListConfigurationSetsIterable;
import software.amazon.awssdk.services.pinpointemail.paginators.ListDedicatedIpPoolsIterable;
import software.amazon.awssdk.services.pinpointemail.paginators.ListDeliverabilityTestReportsIterable;
import software.amazon.awssdk.services.pinpointemail.paginators.ListDomainDeliverabilityCampaignsIterable;
import software.amazon.awssdk.services.pinpointemail.paginators.ListEmailIdentitiesIterable;
import software.amazon.awssdk.services.pinpointemail.transform.CreateConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.CreateConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.CreateDedicatedIpPoolRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.CreateDeliverabilityTestReportRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.CreateEmailIdentityRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.DeleteConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.DeleteConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.DeleteDedicatedIpPoolRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.DeleteEmailIdentityRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetAccountRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetBlacklistReportsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetConfigurationSetEventDestinationsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetDedicatedIpRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetDedicatedIpsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetDeliverabilityDashboardOptionsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetDeliverabilityTestReportRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetDomainDeliverabilityCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetDomainStatisticsReportRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetEmailIdentityRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.ListConfigurationSetsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.ListDedicatedIpPoolsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.ListDeliverabilityTestReportsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.ListDomainDeliverabilityCampaignsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.ListEmailIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutAccountDedicatedIpWarmupAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutAccountSendingAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutConfigurationSetDeliveryOptionsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutConfigurationSetReputationOptionsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutConfigurationSetSendingOptionsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutConfigurationSetTrackingOptionsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutDedicatedIpInPoolRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutDedicatedIpWarmupAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutDeliverabilityDashboardOptionRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutEmailIdentityDkimAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutEmailIdentityFeedbackAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutEmailIdentityMailFromAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.SendEmailRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.UpdateConfigurationSetEventDestinationRequestMarshaller;

@SdkInternalApi
final class DefaultPinpointEmailClient
implements PinpointEmailClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPinpointEmailClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "ses";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConfigurationSetResponse createConfigurationSet(CreateConfigurationSetRequest createConfigurationSetRequest) throws AlreadyExistsException, NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConfigurationSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConfigurationSet");
            CreateConfigurationSetResponse createConfigurationSetResponse = (CreateConfigurationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfigurationSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConfigurationSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateConfigurationSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createConfigurationSetResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, createConfigurationSetRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConfigurationSetEventDestinationResponse createConfigurationSetEventDestination(CreateConfigurationSetEventDestinationRequest createConfigurationSetEventDestinationRequest) throws NotFoundException, AlreadyExistsException, LimitExceededException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConfigurationSetEventDestinationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConfigurationSetEventDestination");
            CreateConfigurationSetEventDestinationResponse createConfigurationSetEventDestinationResponse = (CreateConfigurationSetEventDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfigurationSetEventDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConfigurationSetEventDestinationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateConfigurationSetEventDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createConfigurationSetEventDestinationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, createConfigurationSetEventDestinationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDedicatedIpPoolResponse createDedicatedIpPool(CreateDedicatedIpPoolRequest createDedicatedIpPoolRequest) throws AlreadyExistsException, LimitExceededException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDedicatedIpPoolResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDedicatedIpPool");
            CreateDedicatedIpPoolResponse createDedicatedIpPoolResponse = (CreateDedicatedIpPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDedicatedIpPool").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDedicatedIpPoolRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateDedicatedIpPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDedicatedIpPoolResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, createDedicatedIpPoolRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDeliverabilityTestReportResponse createDeliverabilityTestReport(CreateDeliverabilityTestReportRequest createDeliverabilityTestReportRequest) throws AccountSuspendedException, SendingPausedException, MessageRejectedException, MailFromDomainNotVerifiedException, NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDeliverabilityTestReportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDeliverabilityTestReport");
            CreateDeliverabilityTestReportResponse createDeliverabilityTestReportResponse = (CreateDeliverabilityTestReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDeliverabilityTestReport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDeliverabilityTestReportRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateDeliverabilityTestReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDeliverabilityTestReportResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, createDeliverabilityTestReportRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEmailIdentityResponse createEmailIdentity(CreateEmailIdentityRequest createEmailIdentityRequest) throws LimitExceededException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEmailIdentityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEmailIdentity");
            CreateEmailIdentityResponse createEmailIdentityResponse = (CreateEmailIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEmailIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEmailIdentityRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateEmailIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEmailIdentityResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, createEmailIdentityRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConfigurationSetResponse deleteConfigurationSet(DeleteConfigurationSetRequest deleteConfigurationSetRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigurationSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConfigurationSet");
            DeleteConfigurationSetResponse deleteConfigurationSetResponse = (DeleteConfigurationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigurationSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConfigurationSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConfigurationSetResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, deleteConfigurationSetRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConfigurationSetEventDestinationResponse deleteConfigurationSetEventDestination(DeleteConfigurationSetEventDestinationRequest deleteConfigurationSetEventDestinationRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigurationSetEventDestinationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConfigurationSetEventDestination");
            DeleteConfigurationSetEventDestinationResponse deleteConfigurationSetEventDestinationResponse = (DeleteConfigurationSetEventDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationSetEventDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigurationSetEventDestinationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConfigurationSetEventDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConfigurationSetEventDestinationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, deleteConfigurationSetEventDestinationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDedicatedIpPoolResponse deleteDedicatedIpPool(DeleteDedicatedIpPoolRequest deleteDedicatedIpPoolRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDedicatedIpPoolResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDedicatedIpPool");
            DeleteDedicatedIpPoolResponse deleteDedicatedIpPoolResponse = (DeleteDedicatedIpPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDedicatedIpPool").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDedicatedIpPoolRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDedicatedIpPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDedicatedIpPoolResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, deleteDedicatedIpPoolRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEmailIdentityResponse deleteEmailIdentity(DeleteEmailIdentityRequest deleteEmailIdentityRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEmailIdentityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEmailIdentity");
            DeleteEmailIdentityResponse deleteEmailIdentityResponse = (DeleteEmailIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEmailIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEmailIdentityRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEmailIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEmailIdentityResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, deleteEmailIdentityRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccountResponse getAccount(GetAccountRequest getAccountRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccount");
            GetAccountResponse getAccountResponse = (GetAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAccountRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAccountResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, getAccountRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBlacklistReportsResponse getBlacklistReports(GetBlacklistReportsRequest getBlacklistReportsRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBlacklistReportsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBlacklistReports");
            GetBlacklistReportsResponse getBlacklistReportsResponse = (GetBlacklistReportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBlacklistReports").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getBlacklistReportsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetBlacklistReportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBlacklistReportsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, getBlacklistReportsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetConfigurationSetResponse getConfigurationSet(GetConfigurationSetRequest getConfigurationSetRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConfigurationSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetConfigurationSet");
            GetConfigurationSetResponse getConfigurationSetResponse = (GetConfigurationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConfigurationSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getConfigurationSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetConfigurationSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getConfigurationSetResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, getConfigurationSetRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetConfigurationSetEventDestinationsResponse getConfigurationSetEventDestinations(GetConfigurationSetEventDestinationsRequest getConfigurationSetEventDestinationsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConfigurationSetEventDestinationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetConfigurationSetEventDestinations");
            GetConfigurationSetEventDestinationsResponse getConfigurationSetEventDestinationsResponse = (GetConfigurationSetEventDestinationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConfigurationSetEventDestinations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getConfigurationSetEventDestinationsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetConfigurationSetEventDestinationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getConfigurationSetEventDestinationsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, getConfigurationSetEventDestinationsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDedicatedIpResponse getDedicatedIp(GetDedicatedIpRequest getDedicatedIpRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDedicatedIpResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDedicatedIp");
            GetDedicatedIpResponse getDedicatedIpResponse = (GetDedicatedIpResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDedicatedIp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDedicatedIpRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetDedicatedIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDedicatedIpResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, getDedicatedIpRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDedicatedIpsResponse getDedicatedIps(GetDedicatedIpsRequest getDedicatedIpsRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDedicatedIpsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDedicatedIps");
            GetDedicatedIpsResponse getDedicatedIpsResponse = (GetDedicatedIpsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDedicatedIps").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDedicatedIpsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetDedicatedIpsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDedicatedIpsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, getDedicatedIpsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public GetDedicatedIpsIterable getDedicatedIpsPaginator(GetDedicatedIpsRequest getDedicatedIpsRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        return new GetDedicatedIpsIterable(this, this.applyPaginatorUserAgent(getDedicatedIpsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDeliverabilityDashboardOptionsResponse getDeliverabilityDashboardOptions(GetDeliverabilityDashboardOptionsRequest getDeliverabilityDashboardOptionsRequest) throws TooManyRequestsException, LimitExceededException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDeliverabilityDashboardOptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDeliverabilityDashboardOptions");
            GetDeliverabilityDashboardOptionsResponse getDeliverabilityDashboardOptionsResponse = (GetDeliverabilityDashboardOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDeliverabilityDashboardOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDeliverabilityDashboardOptionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetDeliverabilityDashboardOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDeliverabilityDashboardOptionsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, getDeliverabilityDashboardOptionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDeliverabilityTestReportResponse getDeliverabilityTestReport(GetDeliverabilityTestReportRequest getDeliverabilityTestReportRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDeliverabilityTestReportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDeliverabilityTestReport");
            GetDeliverabilityTestReportResponse getDeliverabilityTestReportResponse = (GetDeliverabilityTestReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDeliverabilityTestReport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDeliverabilityTestReportRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetDeliverabilityTestReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDeliverabilityTestReportResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, getDeliverabilityTestReportRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDomainDeliverabilityCampaignResponse getDomainDeliverabilityCampaign(GetDomainDeliverabilityCampaignRequest getDomainDeliverabilityCampaignRequest) throws TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainDeliverabilityCampaignResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDomainDeliverabilityCampaign");
            GetDomainDeliverabilityCampaignResponse getDomainDeliverabilityCampaignResponse = (GetDomainDeliverabilityCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomainDeliverabilityCampaign").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDomainDeliverabilityCampaignRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetDomainDeliverabilityCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDomainDeliverabilityCampaignResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, getDomainDeliverabilityCampaignRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDomainStatisticsReportResponse getDomainStatisticsReport(GetDomainStatisticsReportRequest getDomainStatisticsReportRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainStatisticsReportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDomainStatisticsReport");
            GetDomainStatisticsReportResponse getDomainStatisticsReportResponse = (GetDomainStatisticsReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomainStatisticsReport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDomainStatisticsReportRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetDomainStatisticsReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDomainStatisticsReportResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, getDomainStatisticsReportRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEmailIdentityResponse getEmailIdentity(GetEmailIdentityRequest getEmailIdentityRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEmailIdentityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEmailIdentity");
            GetEmailIdentityResponse getEmailIdentityResponse = (GetEmailIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEmailIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEmailIdentityRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetEmailIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEmailIdentityResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, getEmailIdentityRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConfigurationSetsResponse listConfigurationSets(ListConfigurationSetsRequest listConfigurationSetsRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConfigurationSetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConfigurationSets");
            ListConfigurationSetsResponse listConfigurationSetsResponse = (ListConfigurationSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConfigurationSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listConfigurationSetsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListConfigurationSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listConfigurationSetsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, listConfigurationSetsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListConfigurationSetsIterable listConfigurationSetsPaginator(ListConfigurationSetsRequest listConfigurationSetsRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        return new ListConfigurationSetsIterable(this, this.applyPaginatorUserAgent(listConfigurationSetsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDedicatedIpPoolsResponse listDedicatedIpPools(ListDedicatedIpPoolsRequest listDedicatedIpPoolsRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDedicatedIpPoolsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDedicatedIpPools");
            ListDedicatedIpPoolsResponse listDedicatedIpPoolsResponse = (ListDedicatedIpPoolsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDedicatedIpPools").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDedicatedIpPoolsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListDedicatedIpPoolsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDedicatedIpPoolsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, listDedicatedIpPoolsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListDedicatedIpPoolsIterable listDedicatedIpPoolsPaginator(ListDedicatedIpPoolsRequest listDedicatedIpPoolsRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        return new ListDedicatedIpPoolsIterable(this, this.applyPaginatorUserAgent(listDedicatedIpPoolsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDeliverabilityTestReportsResponse listDeliverabilityTestReports(ListDeliverabilityTestReportsRequest listDeliverabilityTestReportsRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDeliverabilityTestReportsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDeliverabilityTestReports");
            ListDeliverabilityTestReportsResponse listDeliverabilityTestReportsResponse = (ListDeliverabilityTestReportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDeliverabilityTestReports").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDeliverabilityTestReportsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListDeliverabilityTestReportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDeliverabilityTestReportsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, listDeliverabilityTestReportsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListDeliverabilityTestReportsIterable listDeliverabilityTestReportsPaginator(ListDeliverabilityTestReportsRequest listDeliverabilityTestReportsRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        return new ListDeliverabilityTestReportsIterable(this, this.applyPaginatorUserAgent(listDeliverabilityTestReportsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDomainDeliverabilityCampaignsResponse listDomainDeliverabilityCampaigns(ListDomainDeliverabilityCampaignsRequest listDomainDeliverabilityCampaignsRequest) throws TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainDeliverabilityCampaignsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDomainDeliverabilityCampaigns");
            ListDomainDeliverabilityCampaignsResponse listDomainDeliverabilityCampaignsResponse = (ListDomainDeliverabilityCampaignsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomainDeliverabilityCampaigns").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDomainDeliverabilityCampaignsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListDomainDeliverabilityCampaignsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDomainDeliverabilityCampaignsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, listDomainDeliverabilityCampaignsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListDomainDeliverabilityCampaignsIterable listDomainDeliverabilityCampaignsPaginator(ListDomainDeliverabilityCampaignsRequest listDomainDeliverabilityCampaignsRequest) throws TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException, PinpointEmailException {
        return new ListDomainDeliverabilityCampaignsIterable(this, this.applyPaginatorUserAgent(listDomainDeliverabilityCampaignsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEmailIdentitiesResponse listEmailIdentities(ListEmailIdentitiesRequest listEmailIdentitiesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEmailIdentitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEmailIdentities");
            ListEmailIdentitiesResponse listEmailIdentitiesResponse = (ListEmailIdentitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEmailIdentities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEmailIdentitiesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListEmailIdentitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEmailIdentitiesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, listEmailIdentitiesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListEmailIdentitiesIterable listEmailIdentitiesPaginator(ListEmailIdentitiesRequest listEmailIdentitiesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        return new ListEmailIdentitiesIterable(this, this.applyPaginatorUserAgent(listEmailIdentitiesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws BadRequestException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccountDedicatedIpWarmupAttributesResponse putAccountDedicatedIpWarmupAttributes(PutAccountDedicatedIpWarmupAttributesRequest putAccountDedicatedIpWarmupAttributesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountDedicatedIpWarmupAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccountDedicatedIpWarmupAttributes");
            PutAccountDedicatedIpWarmupAttributesResponse putAccountDedicatedIpWarmupAttributesResponse = (PutAccountDedicatedIpWarmupAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountDedicatedIpWarmupAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putAccountDedicatedIpWarmupAttributesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutAccountDedicatedIpWarmupAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAccountDedicatedIpWarmupAttributesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, putAccountDedicatedIpWarmupAttributesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccountSendingAttributesResponse putAccountSendingAttributes(PutAccountSendingAttributesRequest putAccountSendingAttributesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountSendingAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccountSendingAttributes");
            PutAccountSendingAttributesResponse putAccountSendingAttributesResponse = (PutAccountSendingAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountSendingAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putAccountSendingAttributesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutAccountSendingAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAccountSendingAttributesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, putAccountSendingAttributesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutConfigurationSetDeliveryOptionsResponse putConfigurationSetDeliveryOptions(PutConfigurationSetDeliveryOptionsRequest putConfigurationSetDeliveryOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetDeliveryOptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutConfigurationSetDeliveryOptions");
            PutConfigurationSetDeliveryOptionsResponse putConfigurationSetDeliveryOptionsResponse = (PutConfigurationSetDeliveryOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetDeliveryOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigurationSetDeliveryOptionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutConfigurationSetDeliveryOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putConfigurationSetDeliveryOptionsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, putConfigurationSetDeliveryOptionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutConfigurationSetReputationOptionsResponse putConfigurationSetReputationOptions(PutConfigurationSetReputationOptionsRequest putConfigurationSetReputationOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetReputationOptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutConfigurationSetReputationOptions");
            PutConfigurationSetReputationOptionsResponse putConfigurationSetReputationOptionsResponse = (PutConfigurationSetReputationOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetReputationOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigurationSetReputationOptionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutConfigurationSetReputationOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putConfigurationSetReputationOptionsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, putConfigurationSetReputationOptionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutConfigurationSetSendingOptionsResponse putConfigurationSetSendingOptions(PutConfigurationSetSendingOptionsRequest putConfigurationSetSendingOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetSendingOptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutConfigurationSetSendingOptions");
            PutConfigurationSetSendingOptionsResponse putConfigurationSetSendingOptionsResponse = (PutConfigurationSetSendingOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetSendingOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigurationSetSendingOptionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutConfigurationSetSendingOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putConfigurationSetSendingOptionsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, putConfigurationSetSendingOptionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutConfigurationSetTrackingOptionsResponse putConfigurationSetTrackingOptions(PutConfigurationSetTrackingOptionsRequest putConfigurationSetTrackingOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetTrackingOptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutConfigurationSetTrackingOptions");
            PutConfigurationSetTrackingOptionsResponse putConfigurationSetTrackingOptionsResponse = (PutConfigurationSetTrackingOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetTrackingOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigurationSetTrackingOptionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutConfigurationSetTrackingOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putConfigurationSetTrackingOptionsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, putConfigurationSetTrackingOptionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutDedicatedIpInPoolResponse putDedicatedIpInPool(PutDedicatedIpInPoolRequest putDedicatedIpInPoolRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDedicatedIpInPoolResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDedicatedIpInPool");
            PutDedicatedIpInPoolResponse putDedicatedIpInPoolResponse = (PutDedicatedIpInPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDedicatedIpInPool").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putDedicatedIpInPoolRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutDedicatedIpInPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putDedicatedIpInPoolResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, putDedicatedIpInPoolRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutDedicatedIpWarmupAttributesResponse putDedicatedIpWarmupAttributes(PutDedicatedIpWarmupAttributesRequest putDedicatedIpWarmupAttributesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDedicatedIpWarmupAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDedicatedIpWarmupAttributes");
            PutDedicatedIpWarmupAttributesResponse putDedicatedIpWarmupAttributesResponse = (PutDedicatedIpWarmupAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDedicatedIpWarmupAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putDedicatedIpWarmupAttributesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutDedicatedIpWarmupAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putDedicatedIpWarmupAttributesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, putDedicatedIpWarmupAttributesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutDeliverabilityDashboardOptionResponse putDeliverabilityDashboardOption(PutDeliverabilityDashboardOptionRequest putDeliverabilityDashboardOptionRequest) throws AlreadyExistsException, NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDeliverabilityDashboardOptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDeliverabilityDashboardOption");
            PutDeliverabilityDashboardOptionResponse putDeliverabilityDashboardOptionResponse = (PutDeliverabilityDashboardOptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDeliverabilityDashboardOption").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putDeliverabilityDashboardOptionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutDeliverabilityDashboardOptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putDeliverabilityDashboardOptionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, putDeliverabilityDashboardOptionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutEmailIdentityDkimAttributesResponse putEmailIdentityDkimAttributes(PutEmailIdentityDkimAttributesRequest putEmailIdentityDkimAttributesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEmailIdentityDkimAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutEmailIdentityDkimAttributes");
            PutEmailIdentityDkimAttributesResponse putEmailIdentityDkimAttributesResponse = (PutEmailIdentityDkimAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEmailIdentityDkimAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putEmailIdentityDkimAttributesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutEmailIdentityDkimAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putEmailIdentityDkimAttributesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, putEmailIdentityDkimAttributesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutEmailIdentityFeedbackAttributesResponse putEmailIdentityFeedbackAttributes(PutEmailIdentityFeedbackAttributesRequest putEmailIdentityFeedbackAttributesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEmailIdentityFeedbackAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutEmailIdentityFeedbackAttributes");
            PutEmailIdentityFeedbackAttributesResponse putEmailIdentityFeedbackAttributesResponse = (PutEmailIdentityFeedbackAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEmailIdentityFeedbackAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putEmailIdentityFeedbackAttributesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutEmailIdentityFeedbackAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putEmailIdentityFeedbackAttributesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, putEmailIdentityFeedbackAttributesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutEmailIdentityMailFromAttributesResponse putEmailIdentityMailFromAttributes(PutEmailIdentityMailFromAttributesRequest putEmailIdentityMailFromAttributesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEmailIdentityMailFromAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutEmailIdentityMailFromAttributes");
            PutEmailIdentityMailFromAttributesResponse putEmailIdentityMailFromAttributesResponse = (PutEmailIdentityMailFromAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEmailIdentityMailFromAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putEmailIdentityMailFromAttributesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutEmailIdentityMailFromAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putEmailIdentityMailFromAttributesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, putEmailIdentityMailFromAttributesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendEmailResponse sendEmail(SendEmailRequest sendEmailRequest) throws TooManyRequestsException, LimitExceededException, AccountSuspendedException, SendingPausedException, MessageRejectedException, MailFromDomainNotVerifiedException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendEmailResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendEmail");
            SendEmailResponse sendEmailResponse = (SendEmailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendEmail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendEmailRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new SendEmailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return sendEmailResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, sendEmailRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConfigurationSetEventDestinationResponse updateConfigurationSetEventDestination(UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConfigurationSetEventDestinationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint Email");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConfigurationSetEventDestination");
            UpdateConfigurationSetEventDestinationResponse updateConfigurationSetEventDestinationResponse = (UpdateConfigurationSetEventDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConfigurationSetEventDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConfigurationSetEventDestinationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConfigurationSetEventDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateConfigurationSetEventDestinationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultPinpointEmailClient.resolveMetricPublishers(this.clientConfiguration, updateConfigurationSetEventDestinationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(PinpointEmailException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MessageRejected").exceptionBuilderSupplier(MessageRejectedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SendingPausedException").exceptionBuilderSupplier(SendingPausedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountSuspendedException").exceptionBuilderSupplier(AccountSuspendedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends PinpointEmailRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.62").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((PinpointEmailRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

