/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointemail.PinpointEmailClient;
import software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsResponse;

public class ListDedicatedIpPoolsIterable
implements SdkIterable<ListDedicatedIpPoolsResponse> {
    private final PinpointEmailClient client;
    private final ListDedicatedIpPoolsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDedicatedIpPoolsIterable(PinpointEmailClient client, ListDedicatedIpPoolsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDedicatedIpPoolsResponseFetcher();
    }

    public Iterator<ListDedicatedIpPoolsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListDedicatedIpPoolsIterable resume(ListDedicatedIpPoolsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListDedicatedIpPoolsIterable(this.client, (ListDedicatedIpPoolsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListDedicatedIpPoolsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListDedicatedIpPoolsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListDedicatedIpPoolsResponseFetcher
    implements SyncPageFetcher<ListDedicatedIpPoolsResponse> {
        private ListDedicatedIpPoolsResponseFetcher() {
        }

        public boolean hasNextPage(ListDedicatedIpPoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDedicatedIpPoolsResponse nextPage(ListDedicatedIpPoolsResponse previousPage) {
            if (previousPage == null) {
                return ListDedicatedIpPoolsIterable.this.client.listDedicatedIpPools(ListDedicatedIpPoolsIterable.this.firstRequest);
            }
            return ListDedicatedIpPoolsIterable.this.client.listDedicatedIpPools((ListDedicatedIpPoolsRequest)((Object)ListDedicatedIpPoolsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

