/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.Event;
import software.amazon.awssdk.services.pinpoint.model.MapOfEventCopier;
import software.amazon.awssdk.services.pinpoint.model.PublicEndpoint;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventsBatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventsBatch> {
    private static final SdkField<PublicEndpoint> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EventsBatch.getter(EventsBatch::endpoint)).setter(EventsBatch.setter(Builder::endpoint)).constructor(PublicEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<Map<String, Event>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(EventsBatch.getter(EventsBatch::events)).setter(EventsBatch.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Event::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD, EVENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final PublicEndpoint endpoint;
    private final Map<String, Event> events;

    private EventsBatch(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.events = builder.events;
    }

    public PublicEndpoint endpoint() {
        return this.endpoint;
    }

    public Map<String, Event> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.events());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventsBatch)) {
            return false;
        }
        EventsBatch other = (EventsBatch)obj;
        return Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.events(), other.events());
    }

    public String toString() {
        return ToString.builder((String)"EventsBatch").add("Endpoint", (Object)this.endpoint()).add("Events", this.events()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventsBatch, T> g) {
        return obj -> g.apply((EventsBatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PublicEndpoint endpoint;
        private Map<String, Event> events = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventsBatch model) {
            this.endpoint(model.endpoint);
            this.events(model.events);
        }

        public final PublicEndpoint.Builder getEndpoint() {
            return this.endpoint != null ? this.endpoint.toBuilder() : null;
        }

        @Override
        public final Builder endpoint(PublicEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(PublicEndpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        public final Map<String, Event.Builder> getEvents() {
            return this.events != null ? CollectionUtils.mapValues(this.events, Event::toBuilder) : null;
        }

        @Override
        public final Builder events(Map<String, Event> events) {
            this.events = MapOfEventCopier.copy(events);
            return this;
        }

        public final void setEvents(Map<String, Event.BuilderImpl> events) {
            this.events = MapOfEventCopier.copyFromBuilder(events);
        }

        public EventsBatch build() {
            return new EventsBatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventsBatch> {
        public Builder endpoint(PublicEndpoint var1);

        default public Builder endpoint(Consumer<PublicEndpoint.Builder> endpoint) {
            return this.endpoint((PublicEndpoint)((PublicEndpoint.Builder)PublicEndpoint.builder().applyMutation(endpoint)).build());
        }

        public Builder events(Map<String, Event> var1);
    }
}

