/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum JobStatus {
    CREATED("CREATED"),
    INITIALIZING("INITIALIZING"),
    PROCESSING("PROCESSING"),
    COMPLETING("COMPLETING"),
    COMPLETED("COMPLETED"),
    FAILING("FAILING"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private JobStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(JobStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobStatus> knownValues() {
        return Stream.of(JobStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

