/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.AttributeDimension;
import software.amazon.awssdk.services.pinpoint.model.MapOfAttributeDimensionCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOfMetricDimensionCopier;
import software.amazon.awssdk.services.pinpoint.model.MetricDimension;
import software.amazon.awssdk.services.pinpoint.model.SetDimension;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventDimensions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventDimensions> {
    private static final SdkField<Map<String, AttributeDimension>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(EventDimensions.getter(EventDimensions::attributes)).setter(EventDimensions.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<SetDimension> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EventDimensions.getter(EventDimensions::eventType)).setter(EventDimensions.setter(Builder::eventType)).constructor(SetDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()}).build();
    private static final SdkField<Map<String, MetricDimension>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(EventDimensions.getter(EventDimensions::metrics)).setter(EventDimensions.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, EVENT_TYPE_FIELD, METRICS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, AttributeDimension> attributes;
    private final SetDimension eventType;
    private final Map<String, MetricDimension> metrics;

    private EventDimensions(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.eventType = builder.eventType;
        this.metrics = builder.metrics;
    }

    public Map<String, AttributeDimension> attributes() {
        return this.attributes;
    }

    public SetDimension eventType() {
        return this.eventType;
    }

    public Map<String, MetricDimension> metrics() {
        return this.metrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventType());
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDimensions)) {
            return false;
        }
        EventDimensions other = (EventDimensions)obj;
        return Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.eventType(), other.eventType()) && Objects.equals(this.metrics(), other.metrics());
    }

    public String toString() {
        return ToString.builder((String)"EventDimensions").add("Attributes", this.attributes()).add("EventType", (Object)this.eventType()).add("Metrics", this.metrics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventType()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventDimensions, T> g) {
        return obj -> g.apply((EventDimensions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, AttributeDimension> attributes = DefaultSdkAutoConstructMap.getInstance();
        private SetDimension eventType;
        private Map<String, MetricDimension> metrics = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventDimensions model) {
            this.attributes(model.attributes);
            this.eventType(model.eventType);
            this.metrics(model.metrics);
        }

        public final Map<String, AttributeDimension.Builder> getAttributes() {
            return this.attributes != null ? CollectionUtils.mapValues(this.attributes, AttributeDimension::toBuilder) : null;
        }

        @Override
        public final Builder attributes(Map<String, AttributeDimension> attributes) {
            this.attributes = MapOfAttributeDimensionCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, AttributeDimension.BuilderImpl> attributes) {
            this.attributes = MapOfAttributeDimensionCopier.copyFromBuilder(attributes);
        }

        public final SetDimension.Builder getEventType() {
            return this.eventType != null ? this.eventType.toBuilder() : null;
        }

        @Override
        public final Builder eventType(SetDimension eventType) {
            this.eventType = eventType;
            return this;
        }

        public final void setEventType(SetDimension.BuilderImpl eventType) {
            this.eventType = eventType != null ? eventType.build() : null;
        }

        public final Map<String, MetricDimension.Builder> getMetrics() {
            return this.metrics != null ? CollectionUtils.mapValues(this.metrics, MetricDimension::toBuilder) : null;
        }

        @Override
        public final Builder metrics(Map<String, MetricDimension> metrics) {
            this.metrics = MapOfMetricDimensionCopier.copy(metrics);
            return this;
        }

        public final void setMetrics(Map<String, MetricDimension.BuilderImpl> metrics) {
            this.metrics = MapOfMetricDimensionCopier.copyFromBuilder(metrics);
        }

        public EventDimensions build() {
            return new EventDimensions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventDimensions> {
        public Builder attributes(Map<String, AttributeDimension> var1);

        public Builder eventType(SetDimension var1);

        default public Builder eventType(Consumer<SetDimension.Builder> eventType) {
            return this.eventType((SetDimension)((SetDimension.Builder)SetDimension.builder().applyMutation(eventType)).build());
        }

        public Builder metrics(Map<String, MetricDimension> var1);
    }
}

