/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.CampaignEventFilter;
import software.amazon.awssdk.services.pinpoint.model.Frequency;
import software.amazon.awssdk.services.pinpoint.model.QuietTime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Schedule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Schedule> {
    private static final SdkField<String> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Schedule.getter(Schedule::endTime)).setter(Schedule.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<CampaignEventFilter> EVENT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Schedule.getter(Schedule::eventFilter)).setter(Schedule.setter(Builder::eventFilter)).constructor(CampaignEventFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventFilter").build()}).build();
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Schedule.getter(Schedule::frequencyAsString)).setter(Schedule.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency").build()}).build();
    private static final SdkField<Boolean> IS_LOCAL_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Schedule.getter(Schedule::isLocalTime)).setter(Schedule.setter(Builder::isLocalTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLocalTime").build()}).build();
    private static final SdkField<QuietTime> QUIET_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Schedule.getter(Schedule::quietTime)).setter(Schedule.setter(Builder::quietTime)).constructor(QuietTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuietTime").build()}).build();
    private static final SdkField<String> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Schedule.getter(Schedule::startTime)).setter(Schedule.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Schedule.getter(Schedule::timezone)).setter(Schedule.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, EVENT_FILTER_FIELD, FREQUENCY_FIELD, IS_LOCAL_TIME_FIELD, QUIET_TIME_FIELD, START_TIME_FIELD, TIMEZONE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String endTime;
    private final CampaignEventFilter eventFilter;
    private final String frequency;
    private final Boolean isLocalTime;
    private final QuietTime quietTime;
    private final String startTime;
    private final String timezone;

    private Schedule(BuilderImpl builder) {
        this.endTime = builder.endTime;
        this.eventFilter = builder.eventFilter;
        this.frequency = builder.frequency;
        this.isLocalTime = builder.isLocalTime;
        this.quietTime = builder.quietTime;
        this.startTime = builder.startTime;
        this.timezone = builder.timezone;
    }

    public String endTime() {
        return this.endTime;
    }

    public CampaignEventFilter eventFilter() {
        return this.eventFilter;
    }

    public Frequency frequency() {
        return Frequency.fromValue(this.frequency);
    }

    public String frequencyAsString() {
        return this.frequency;
    }

    public Boolean isLocalTime() {
        return this.isLocalTime;
    }

    public QuietTime quietTime() {
        return this.quietTime;
    }

    public String startTime() {
        return this.startTime;
    }

    public String timezone() {
        return this.timezone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isLocalTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.quietTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)obj;
        return Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.eventFilter(), other.eventFilter()) && Objects.equals(this.frequencyAsString(), other.frequencyAsString()) && Objects.equals(this.isLocalTime(), other.isLocalTime()) && Objects.equals(this.quietTime(), other.quietTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.timezone(), other.timezone());
    }

    public String toString() {
        return ToString.builder((String)"Schedule").add("EndTime", (Object)this.endTime()).add("EventFilter", (Object)this.eventFilter()).add("Frequency", (Object)this.frequencyAsString()).add("IsLocalTime", (Object)this.isLocalTime()).add("QuietTime", (Object)this.quietTime()).add("StartTime", (Object)this.startTime()).add("Timezone", (Object)this.timezone()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "EventFilter": {
                return Optional.ofNullable(clazz.cast(this.eventFilter()));
            }
            case "Frequency": {
                return Optional.ofNullable(clazz.cast(this.frequencyAsString()));
            }
            case "IsLocalTime": {
                return Optional.ofNullable(clazz.cast(this.isLocalTime()));
            }
            case "QuietTime": {
                return Optional.ofNullable(clazz.cast(this.quietTime()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Schedule, T> g) {
        return obj -> g.apply((Schedule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endTime;
        private CampaignEventFilter eventFilter;
        private String frequency;
        private Boolean isLocalTime;
        private QuietTime quietTime;
        private String startTime;
        private String timezone;

        private BuilderImpl() {
        }

        private BuilderImpl(Schedule model) {
            this.endTime(model.endTime);
            this.eventFilter(model.eventFilter);
            this.frequency(model.frequency);
            this.isLocalTime(model.isLocalTime);
            this.quietTime(model.quietTime);
            this.startTime(model.startTime);
            this.timezone(model.timezone);
        }

        public final String getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public final CampaignEventFilter.Builder getEventFilter() {
            return this.eventFilter != null ? this.eventFilter.toBuilder() : null;
        }

        @Override
        public final Builder eventFilter(CampaignEventFilter eventFilter) {
            this.eventFilter = eventFilter;
            return this;
        }

        public final void setEventFilter(CampaignEventFilter.BuilderImpl eventFilter) {
            this.eventFilter = eventFilter != null ? eventFilter.build() : null;
        }

        public final String getFrequencyAsString() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(Frequency frequency) {
            this.frequency(frequency.toString());
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final Boolean getIsLocalTime() {
            return this.isLocalTime;
        }

        @Override
        public final Builder isLocalTime(Boolean isLocalTime) {
            this.isLocalTime = isLocalTime;
            return this;
        }

        public final void setIsLocalTime(Boolean isLocalTime) {
            this.isLocalTime = isLocalTime;
        }

        public final QuietTime.Builder getQuietTime() {
            return this.quietTime != null ? this.quietTime.toBuilder() : null;
        }

        @Override
        public final Builder quietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
            return this;
        }

        public final void setQuietTime(QuietTime.BuilderImpl quietTime) {
            this.quietTime = quietTime != null ? quietTime.build() : null;
        }

        public final String getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public Schedule build() {
            return new Schedule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Schedule> {
        public Builder endTime(String var1);

        public Builder eventFilter(CampaignEventFilter var1);

        default public Builder eventFilter(Consumer<CampaignEventFilter.Builder> eventFilter) {
            return this.eventFilter((CampaignEventFilter)((CampaignEventFilter.Builder)CampaignEventFilter.builder().applyMutation(eventFilter)).build());
        }

        public Builder frequency(String var1);

        public Builder frequency(Frequency var1);

        public Builder isLocalTime(Boolean var1);

        public Builder quietTime(QuietTime var1);

        default public Builder quietTime(Consumer<QuietTime.Builder> quietTime) {
            return this.quietTime((QuietTime)((QuietTime.Builder)QuietTime.builder().applyMutation(quietTime)).build());
        }

        public Builder startTime(String var1);

        public Builder timezone(String var1);
    }
}

