/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.EndpointBatchRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEndpointsBatchRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateEndpointsBatchRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(UpdateEndpointsBatchRequest.getter(UpdateEndpointsBatchRequest::applicationId)).setter(UpdateEndpointsBatchRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<EndpointBatchRequest> ENDPOINT_BATCH_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointBatchRequest").getter(UpdateEndpointsBatchRequest.getter(UpdateEndpointsBatchRequest::endpointBatchRequest)).setter(UpdateEndpointsBatchRequest.setter(Builder::endpointBatchRequest)).constructor(EndpointBatchRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointBatchRequest").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, ENDPOINT_BATCH_REQUEST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateEndpointsBatchRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final EndpointBatchRequest endpointBatchRequest;

    private UpdateEndpointsBatchRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.endpointBatchRequest = builder.endpointBatchRequest;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final EndpointBatchRequest endpointBatchRequest() {
        return this.endpointBatchRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointBatchRequest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointsBatchRequest)) {
            return false;
        }
        UpdateEndpointsBatchRequest other = (UpdateEndpointsBatchRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.endpointBatchRequest(), other.endpointBatchRequest());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEndpointsBatchRequest").add("ApplicationId", (Object)this.applicationId()).add("EndpointBatchRequest", (Object)this.endpointBatchRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "EndpointBatchRequest": {
                return Optional.ofNullable(clazz.cast(this.endpointBatchRequest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("application-id", APPLICATION_ID_FIELD);
        map.put("EndpointBatchRequest", ENDPOINT_BATCH_REQUEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEndpointsBatchRequest, T> g) {
        return obj -> g.apply((UpdateEndpointsBatchRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private EndpointBatchRequest endpointBatchRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointsBatchRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.endpointBatchRequest(model.endpointBatchRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final EndpointBatchRequest.Builder getEndpointBatchRequest() {
            return this.endpointBatchRequest != null ? this.endpointBatchRequest.toBuilder() : null;
        }

        public final void setEndpointBatchRequest(EndpointBatchRequest.BuilderImpl endpointBatchRequest) {
            this.endpointBatchRequest = endpointBatchRequest != null ? endpointBatchRequest.build() : null;
        }

        @Override
        public final Builder endpointBatchRequest(EndpointBatchRequest endpointBatchRequest) {
            this.endpointBatchRequest = endpointBatchRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEndpointsBatchRequest build() {
            return new UpdateEndpointsBatchRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEndpointsBatchRequest> {
        public Builder applicationId(String var1);

        public Builder endpointBatchRequest(EndpointBatchRequest var1);

        default public Builder endpointBatchRequest(Consumer<EndpointBatchRequest.Builder> endpointBatchRequest) {
            return this.endpointBatchRequest((EndpointBatchRequest)((EndpointBatchRequest.Builder)EndpointBatchRequest.builder().applyMutation(endpointBatchRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

