/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecencyType {
    ACTIVE("ACTIVE"),
    INACTIVE("INACTIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecencyType> VALUE_MAP;
    private final String value;

    private RecencyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecencyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecencyType> knownValues() {
        EnumSet<RecencyType> knownValues = EnumSet.allOf(RecencyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecencyType.class, RecencyType::toString);
    }
}

