/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.ListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.RawEmail;
import software.amazon.awssdk.services.pinpoint.model.SimpleEmail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmailMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmailMessage> {
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Body").getter(EmailMessage.getter(EmailMessage::body)).setter(EmailMessage.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<String> FEEDBACK_FORWARDING_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeedbackForwardingAddress").getter(EmailMessage.getter(EmailMessage::feedbackForwardingAddress)).setter(EmailMessage.setter(Builder::feedbackForwardingAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackForwardingAddress").build()}).build();
    private static final SdkField<String> FROM_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FromAddress").getter(EmailMessage.getter(EmailMessage::fromAddress)).setter(EmailMessage.setter(Builder::fromAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromAddress").build()}).build();
    private static final SdkField<RawEmail> RAW_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RawEmail").getter(EmailMessage.getter(EmailMessage::rawEmail)).setter(EmailMessage.setter(Builder::rawEmail)).constructor(RawEmail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawEmail").build()}).build();
    private static final SdkField<List<String>> REPLY_TO_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplyToAddresses").getter(EmailMessage.getter(EmailMessage::replyToAddresses)).setter(EmailMessage.setter(Builder::replyToAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplyToAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SimpleEmail> SIMPLE_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SimpleEmail").getter(EmailMessage.getter(EmailMessage::simpleEmail)).setter(EmailMessage.setter(Builder::simpleEmail)).constructor(SimpleEmail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SimpleEmail").build()}).build();
    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Substitutions").getter(EmailMessage.getter(EmailMessage::substitutions)).setter(EmailMessage.setter(Builder::substitutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, FEEDBACK_FORWARDING_ADDRESS_FIELD, FROM_ADDRESS_FIELD, RAW_EMAIL_FIELD, REPLY_TO_ADDRESSES_FIELD, SIMPLE_EMAIL_FIELD, SUBSTITUTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EmailMessage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String body;
    private final String feedbackForwardingAddress;
    private final String fromAddress;
    private final RawEmail rawEmail;
    private final List<String> replyToAddresses;
    private final SimpleEmail simpleEmail;
    private final Map<String, List<String>> substitutions;

    private EmailMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.feedbackForwardingAddress = builder.feedbackForwardingAddress;
        this.fromAddress = builder.fromAddress;
        this.rawEmail = builder.rawEmail;
        this.replyToAddresses = builder.replyToAddresses;
        this.simpleEmail = builder.simpleEmail;
        this.substitutions = builder.substitutions;
    }

    public final String body() {
        return this.body;
    }

    public final String feedbackForwardingAddress() {
        return this.feedbackForwardingAddress;
    }

    public final String fromAddress() {
        return this.fromAddress;
    }

    public final RawEmail rawEmail() {
        return this.rawEmail;
    }

    public final boolean hasReplyToAddresses() {
        return this.replyToAddresses != null && !(this.replyToAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> replyToAddresses() {
        return this.replyToAddresses;
    }

    public final SimpleEmail simpleEmail() {
        return this.simpleEmail;
    }

    public final boolean hasSubstitutions() {
        return this.substitutions != null && !(this.substitutions instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> substitutions() {
        return this.substitutions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackForwardingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplyToAddresses() ? this.replyToAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.simpleEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubstitutions() ? this.substitutions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailMessage)) {
            return false;
        }
        EmailMessage other = (EmailMessage)obj;
        return Objects.equals(this.body(), other.body()) && Objects.equals(this.feedbackForwardingAddress(), other.feedbackForwardingAddress()) && Objects.equals(this.fromAddress(), other.fromAddress()) && Objects.equals(this.rawEmail(), other.rawEmail()) && this.hasReplyToAddresses() == other.hasReplyToAddresses() && Objects.equals(this.replyToAddresses(), other.replyToAddresses()) && Objects.equals(this.simpleEmail(), other.simpleEmail()) && this.hasSubstitutions() == other.hasSubstitutions() && Objects.equals(this.substitutions(), other.substitutions());
    }

    public final String toString() {
        return ToString.builder((String)"EmailMessage").add("Body", (Object)this.body()).add("FeedbackForwardingAddress", (Object)this.feedbackForwardingAddress()).add("FromAddress", (Object)this.fromAddress()).add("RawEmail", (Object)this.rawEmail()).add("ReplyToAddresses", this.hasReplyToAddresses() ? this.replyToAddresses() : null).add("SimpleEmail", (Object)this.simpleEmail()).add("Substitutions", this.hasSubstitutions() ? this.substitutions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "FeedbackForwardingAddress": {
                return Optional.ofNullable(clazz.cast(this.feedbackForwardingAddress()));
            }
            case "FromAddress": {
                return Optional.ofNullable(clazz.cast(this.fromAddress()));
            }
            case "RawEmail": {
                return Optional.ofNullable(clazz.cast(this.rawEmail()));
            }
            case "ReplyToAddresses": {
                return Optional.ofNullable(clazz.cast(this.replyToAddresses()));
            }
            case "SimpleEmail": {
                return Optional.ofNullable(clazz.cast(this.simpleEmail()));
            }
            case "Substitutions": {
                return Optional.ofNullable(clazz.cast(this.substitutions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Body", BODY_FIELD);
        map.put("FeedbackForwardingAddress", FEEDBACK_FORWARDING_ADDRESS_FIELD);
        map.put("FromAddress", FROM_ADDRESS_FIELD);
        map.put("RawEmail", RAW_EMAIL_FIELD);
        map.put("ReplyToAddresses", REPLY_TO_ADDRESSES_FIELD);
        map.put("SimpleEmail", SIMPLE_EMAIL_FIELD);
        map.put("Substitutions", SUBSTITUTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailMessage, T> g) {
        return obj -> g.apply((EmailMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String body;
        private String feedbackForwardingAddress;
        private String fromAddress;
        private RawEmail rawEmail;
        private List<String> replyToAddresses = DefaultSdkAutoConstructList.getInstance();
        private SimpleEmail simpleEmail;
        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EmailMessage model) {
            this.body(model.body);
            this.feedbackForwardingAddress(model.feedbackForwardingAddress);
            this.fromAddress(model.fromAddress);
            this.rawEmail(model.rawEmail);
            this.replyToAddresses(model.replyToAddresses);
            this.simpleEmail(model.simpleEmail);
            this.substitutions(model.substitutions);
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getFeedbackForwardingAddress() {
            return this.feedbackForwardingAddress;
        }

        public final void setFeedbackForwardingAddress(String feedbackForwardingAddress) {
            this.feedbackForwardingAddress = feedbackForwardingAddress;
        }

        @Override
        public final Builder feedbackForwardingAddress(String feedbackForwardingAddress) {
            this.feedbackForwardingAddress = feedbackForwardingAddress;
            return this;
        }

        public final String getFromAddress() {
            return this.fromAddress;
        }

        public final void setFromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
        }

        @Override
        public final Builder fromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public final RawEmail.Builder getRawEmail() {
            return this.rawEmail != null ? this.rawEmail.toBuilder() : null;
        }

        public final void setRawEmail(RawEmail.BuilderImpl rawEmail) {
            this.rawEmail = rawEmail != null ? rawEmail.build() : null;
        }

        @Override
        public final Builder rawEmail(RawEmail rawEmail) {
            this.rawEmail = rawEmail;
            return this;
        }

        public final Collection<String> getReplyToAddresses() {
            if (this.replyToAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replyToAddresses;
        }

        public final void setReplyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = ListOf__stringCopier.copy(replyToAddresses);
        }

        @Override
        public final Builder replyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = ListOf__stringCopier.copy(replyToAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replyToAddresses(String ... replyToAddresses) {
            this.replyToAddresses(Arrays.asList(replyToAddresses));
            return this;
        }

        public final SimpleEmail.Builder getSimpleEmail() {
            return this.simpleEmail != null ? this.simpleEmail.toBuilder() : null;
        }

        public final void setSimpleEmail(SimpleEmail.BuilderImpl simpleEmail) {
            this.simpleEmail = simpleEmail != null ? simpleEmail.build() : null;
        }

        @Override
        public final Builder simpleEmail(SimpleEmail simpleEmail) {
            this.simpleEmail = simpleEmail;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            if (this.substitutions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.substitutions;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public EmailMessage build() {
            return new EmailMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmailMessage> {
        public Builder body(String var1);

        public Builder feedbackForwardingAddress(String var1);

        public Builder fromAddress(String var1);

        public Builder rawEmail(RawEmail var1);

        default public Builder rawEmail(Consumer<RawEmail.Builder> rawEmail) {
            return this.rawEmail((RawEmail)((RawEmail.Builder)RawEmail.builder().applyMutation(rawEmail)).build());
        }

        public Builder replyToAddresses(Collection<String> var1);

        public Builder replyToAddresses(String ... var1);

        public Builder simpleEmail(SimpleEmail var1);

        default public Builder simpleEmail(Consumer<SimpleEmail.Builder> simpleEmail) {
            return this.simpleEmail((SimpleEmail)((SimpleEmail.Builder)SimpleEmail.builder().applyMutation(simpleEmail)).build());
        }

        public Builder substitutions(Map<String, ? extends Collection<String>> var1);
    }
}

