/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the subject or body of an email message, represented as textual email data and the applicable character
 * set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimpleEmailPart implements SdkPojo, Serializable, ToCopyableBuilder<SimpleEmailPart.Builder, SimpleEmailPart> {
    private static final SdkField<String> CHARSET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Charset")
            .getter(getter(SimpleEmailPart::charset)).setter(setter(Builder::charset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Charset").build()).build();

    private static final SdkField<String> DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Data")
            .getter(getter(SimpleEmailPart::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHARSET_FIELD, DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String charset;

    private final String data;

    private SimpleEmailPart(BuilderImpl builder) {
        this.charset = builder.charset;
        this.data = builder.data;
    }

    /**
     * <p>
     * The applicable character set for the message content.
     * </p>
     * 
     * @return The applicable character set for the message content.
     */
    public final String charset() {
        return charset;
    }

    /**
     * <p>
     * The textual data of the message content.
     * </p>
     * 
     * @return The textual data of the message content.
     */
    public final String data() {
        return data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(charset());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleEmailPart)) {
            return false;
        }
        SimpleEmailPart other = (SimpleEmailPart) obj;
        return Objects.equals(charset(), other.charset()) && Objects.equals(data(), other.data());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SimpleEmailPart").add("Charset", charset()).add("Data", data()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Charset":
            return Optional.ofNullable(clazz.cast(charset()));
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Charset", CHARSET_FIELD);
        map.put("Data", DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SimpleEmailPart, T> g) {
        return obj -> g.apply((SimpleEmailPart) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SimpleEmailPart> {
        /**
         * <p>
         * The applicable character set for the message content.
         * </p>
         * 
         * @param charset
         *        The applicable character set for the message content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder charset(String charset);

        /**
         * <p>
         * The textual data of the message content.
         * </p>
         * 
         * @param data
         *        The textual data of the message content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(String data);
    }

    static final class BuilderImpl implements Builder {
        private String charset;

        private String data;

        private BuilderImpl() {
        }

        private BuilderImpl(SimpleEmailPart model) {
            charset(model.charset);
            data(model.data);
        }

        public final String getCharset() {
            return charset;
        }

        public final void setCharset(String charset) {
            this.charset = charset;
        }

        @Override
        public final Builder charset(String charset) {
            this.charset = charset;
            return this;
        }

        public final String getData() {
            return data;
        }

        public final void setData(String data) {
            this.data = data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        @Override
        public SimpleEmailPart build() {
            return new SimpleEmailPart(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
