/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Changes the status of a journey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JourneyStateRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<JourneyStateRequest.Builder, JourneyStateRequest> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(JourneyStateRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String state;

    private JourneyStateRequest(BuilderImpl builder) {
        this.state = builder.state;
    }

    /**
     * <p>
     * The status of the journey. Currently, Supported values are ACTIVE, PAUSED, and CANCELLED
     * </p>
     * <p>
     * If you cancel a journey, Amazon Pinpoint continues to perform activities that are currently in progress, until
     * those activities are complete. Amazon Pinpoint also continues to collect and aggregate analytics data for those
     * activities, until they are complete, and any activities that were complete when you cancelled the journey.
     * </p>
     * <p>
     * After you cancel a journey, you can't add, change, or remove any activities from the journey. In addition, Amazon
     * Pinpoint stops evaluating the journey and doesn't perform any activities that haven't started.
     * </p>
     * <p>
     * When the journey is paused, Amazon Pinpoint continues to perform activities that are currently in progress, until
     * those activities are complete. Endpoints will stop entering journeys when the journey is paused and will resume
     * entering the journey after the journey is resumed. For wait activities, wait time is paused when the journey is
     * paused. Currently, PAUSED only supports journeys with a segment refresh interval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The status of the journey. Currently, Supported values are ACTIVE, PAUSED, and CANCELLED</p>
     *         <p>
     *         If you cancel a journey, Amazon Pinpoint continues to perform activities that are currently in progress,
     *         until those activities are complete. Amazon Pinpoint also continues to collect and aggregate analytics
     *         data for those activities, until they are complete, and any activities that were complete when you
     *         cancelled the journey.
     *         </p>
     *         <p>
     *         After you cancel a journey, you can't add, change, or remove any activities from the journey. In
     *         addition, Amazon Pinpoint stops evaluating the journey and doesn't perform any activities that haven't
     *         started.
     *         </p>
     *         <p>
     *         When the journey is paused, Amazon Pinpoint continues to perform activities that are currently in
     *         progress, until those activities are complete. Endpoints will stop entering journeys when the journey is
     *         paused and will resume entering the journey after the journey is resumed. For wait activities, wait time
     *         is paused when the journey is paused. Currently, PAUSED only supports journeys with a segment refresh
     *         interval.
     * @see State
     */
    public final State state() {
        return State.fromValue(state);
    }

    /**
     * <p>
     * The status of the journey. Currently, Supported values are ACTIVE, PAUSED, and CANCELLED
     * </p>
     * <p>
     * If you cancel a journey, Amazon Pinpoint continues to perform activities that are currently in progress, until
     * those activities are complete. Amazon Pinpoint also continues to collect and aggregate analytics data for those
     * activities, until they are complete, and any activities that were complete when you cancelled the journey.
     * </p>
     * <p>
     * After you cancel a journey, you can't add, change, or remove any activities from the journey. In addition, Amazon
     * Pinpoint stops evaluating the journey and doesn't perform any activities that haven't started.
     * </p>
     * <p>
     * When the journey is paused, Amazon Pinpoint continues to perform activities that are currently in progress, until
     * those activities are complete. Endpoints will stop entering journeys when the journey is paused and will resume
     * entering the journey after the journey is resumed. For wait activities, wait time is paused when the journey is
     * paused. Currently, PAUSED only supports journeys with a segment refresh interval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The status of the journey. Currently, Supported values are ACTIVE, PAUSED, and CANCELLED</p>
     *         <p>
     *         If you cancel a journey, Amazon Pinpoint continues to perform activities that are currently in progress,
     *         until those activities are complete. Amazon Pinpoint also continues to collect and aggregate analytics
     *         data for those activities, until they are complete, and any activities that were complete when you
     *         cancelled the journey.
     *         </p>
     *         <p>
     *         After you cancel a journey, you can't add, change, or remove any activities from the journey. In
     *         addition, Amazon Pinpoint stops evaluating the journey and doesn't perform any activities that haven't
     *         started.
     *         </p>
     *         <p>
     *         When the journey is paused, Amazon Pinpoint continues to perform activities that are currently in
     *         progress, until those activities are complete. Endpoints will stop entering journeys when the journey is
     *         paused and will resume entering the journey after the journey is resumed. For wait activities, wait time
     *         is paused when the journey is paused. Currently, PAUSED only supports journeys with a segment refresh
     *         interval.
     * @see State
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JourneyStateRequest)) {
            return false;
        }
        JourneyStateRequest other = (JourneyStateRequest) obj;
        return Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JourneyStateRequest").add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JourneyStateRequest, T> g) {
        return obj -> g.apply((JourneyStateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JourneyStateRequest> {
        /**
         * <p>
         * The status of the journey. Currently, Supported values are ACTIVE, PAUSED, and CANCELLED
         * </p>
         * <p>
         * If you cancel a journey, Amazon Pinpoint continues to perform activities that are currently in progress,
         * until those activities are complete. Amazon Pinpoint also continues to collect and aggregate analytics data
         * for those activities, until they are complete, and any activities that were complete when you cancelled the
         * journey.
         * </p>
         * <p>
         * After you cancel a journey, you can't add, change, or remove any activities from the journey. In addition,
         * Amazon Pinpoint stops evaluating the journey and doesn't perform any activities that haven't started.
         * </p>
         * <p>
         * When the journey is paused, Amazon Pinpoint continues to perform activities that are currently in progress,
         * until those activities are complete. Endpoints will stop entering journeys when the journey is paused and
         * will resume entering the journey after the journey is resumed. For wait activities, wait time is paused when
         * the journey is paused. Currently, PAUSED only supports journeys with a segment refresh interval.
         * </p>
         * 
         * @param state
         *        The status of the journey. Currently, Supported values are ACTIVE, PAUSED, and CANCELLED</p>
         *        <p>
         *        If you cancel a journey, Amazon Pinpoint continues to perform activities that are currently in
         *        progress, until those activities are complete. Amazon Pinpoint also continues to collect and aggregate
         *        analytics data for those activities, until they are complete, and any activities that were complete
         *        when you cancelled the journey.
         *        </p>
         *        <p>
         *        After you cancel a journey, you can't add, change, or remove any activities from the journey. In
         *        addition, Amazon Pinpoint stops evaluating the journey and doesn't perform any activities that haven't
         *        started.
         *        </p>
         *        <p>
         *        When the journey is paused, Amazon Pinpoint continues to perform activities that are currently in
         *        progress, until those activities are complete. Endpoints will stop entering journeys when the journey
         *        is paused and will resume entering the journey after the journey is resumed. For wait activities, wait
         *        time is paused when the journey is paused. Currently, PAUSED only supports journeys with a segment
         *        refresh interval.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(String state);

        /**
         * <p>
         * The status of the journey. Currently, Supported values are ACTIVE, PAUSED, and CANCELLED
         * </p>
         * <p>
         * If you cancel a journey, Amazon Pinpoint continues to perform activities that are currently in progress,
         * until those activities are complete. Amazon Pinpoint also continues to collect and aggregate analytics data
         * for those activities, until they are complete, and any activities that were complete when you cancelled the
         * journey.
         * </p>
         * <p>
         * After you cancel a journey, you can't add, change, or remove any activities from the journey. In addition,
         * Amazon Pinpoint stops evaluating the journey and doesn't perform any activities that haven't started.
         * </p>
         * <p>
         * When the journey is paused, Amazon Pinpoint continues to perform activities that are currently in progress,
         * until those activities are complete. Endpoints will stop entering journeys when the journey is paused and
         * will resume entering the journey after the journey is resumed. For wait activities, wait time is paused when
         * the journey is paused. Currently, PAUSED only supports journeys with a segment refresh interval.
         * </p>
         * 
         * @param state
         *        The status of the journey. Currently, Supported values are ACTIVE, PAUSED, and CANCELLED</p>
         *        <p>
         *        If you cancel a journey, Amazon Pinpoint continues to perform activities that are currently in
         *        progress, until those activities are complete. Amazon Pinpoint also continues to collect and aggregate
         *        analytics data for those activities, until they are complete, and any activities that were complete
         *        when you cancelled the journey.
         *        </p>
         *        <p>
         *        After you cancel a journey, you can't add, change, or remove any activities from the journey. In
         *        addition, Amazon Pinpoint stops evaluating the journey and doesn't perform any activities that haven't
         *        started.
         *        </p>
         *        <p>
         *        When the journey is paused, Amazon Pinpoint continues to perform activities that are currently in
         *        progress, until those activities are complete. Endpoints will stop entering journeys when the journey
         *        is paused and will resume entering the journey after the journey is resumed. For wait activities, wait
         *        time is paused when the journey is paused. Currently, PAUSED only supports journeys with a segment
         *        refresh interval.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(State state);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(JourneyStateRequest model) {
            state(model.state);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public JourneyStateRequest build() {
            return new JourneyStateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
