/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJourneyRunExecutionMetricsRequest extends PinpointRequest implements
        ToCopyableBuilder<GetJourneyRunExecutionMetricsRequest.Builder, GetJourneyRunExecutionMetricsRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(GetJourneyRunExecutionMetricsRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()).build();

    private static final SdkField<String> JOURNEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JourneyId").getter(getter(GetJourneyRunExecutionMetricsRequest::journeyId))
            .setter(setter(Builder::journeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("journey-id").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetJourneyRunExecutionMetricsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()).build();

    private static final SdkField<String> PAGE_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PageSize").getter(getter(GetJourneyRunExecutionMetricsRequest::pageSize))
            .setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("page-size").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RunId")
            .getter(getter(GetJourneyRunExecutionMetricsRequest::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("run-id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            JOURNEY_ID_FIELD, NEXT_TOKEN_FIELD, PAGE_SIZE_FIELD, RUN_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String journeyId;

    private final String nextToken;

    private final String pageSize;

    private final String runId;

    private GetJourneyRunExecutionMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.journeyId = builder.journeyId;
        this.nextToken = builder.nextToken;
        this.pageSize = builder.pageSize;
        this.runId = builder.runId;
    }

    /**
     * <p>
     * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon
     * Pinpoint console.
     * </p>
     * 
     * @return The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
     *         Amazon Pinpoint console.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The unique identifier for the journey.
     * </p>
     * 
     * @return The unique identifier for the journey.
     */
    public final String journeyId() {
        return journeyId;
    }

    /**
     * <p>
     * The
     * <code/> string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.
     * </p>
     * 
     * @return The
     *         <code/> string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to include in each page of a paginated response. This parameter is not supported for
     * application, campaign, and journey metrics.
     * </p>
     * 
     * @return The maximum number of items to include in each page of a paginated response. This parameter is not
     *         supported for application, campaign, and journey metrics.
     */
    public final String pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * The unique identifier for the journey run.
     * </p>
     * 
     * @return The unique identifier for the journey run.
     */
    public final String runId() {
        return runId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(journeyId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJourneyRunExecutionMetricsRequest)) {
            return false;
        }
        GetJourneyRunExecutionMetricsRequest other = (GetJourneyRunExecutionMetricsRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(journeyId(), other.journeyId())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(pageSize(), other.pageSize())
                && Objects.equals(runId(), other.runId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetJourneyRunExecutionMetricsRequest").add("ApplicationId", applicationId())
                .add("JourneyId", journeyId()).add("NextToken", nextToken()).add("PageSize", pageSize()).add("RunId", runId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "JourneyId":
            return Optional.ofNullable(clazz.cast(journeyId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "RunId":
            return Optional.ofNullable(clazz.cast(runId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("application-id", APPLICATION_ID_FIELD);
        map.put("journey-id", JOURNEY_ID_FIELD);
        map.put("next-token", NEXT_TOKEN_FIELD);
        map.put("page-size", PAGE_SIZE_FIELD);
        map.put("run-id", RUN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetJourneyRunExecutionMetricsRequest, T> g) {
        return obj -> g.apply((GetJourneyRunExecutionMetricsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetJourneyRunExecutionMetricsRequest> {
        /**
         * <p>
         * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
         * Amazon Pinpoint console.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on
         *        the Amazon Pinpoint console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The unique identifier for the journey.
         * </p>
         * 
         * @param journeyId
         *        The unique identifier for the journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder journeyId(String journeyId);

        /**
         * <p>
         * The
         * <code/> string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.
         * </p>
         * 
         * @param nextToken
         *        The
         *        <code/> string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to include in each page of a paginated response. This parameter is not supported
         * for application, campaign, and journey metrics.
         * </p>
         * 
         * @param pageSize
         *        The maximum number of items to include in each page of a paginated response. This parameter is not
         *        supported for application, campaign, and journey metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(String pageSize);

        /**
         * <p>
         * The unique identifier for the journey run.
         * </p>
         * 
         * @param runId
         *        The unique identifier for the journey run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String journeyId;

        private String nextToken;

        private String pageSize;

        private String runId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJourneyRunExecutionMetricsRequest model) {
            super(model);
            applicationId(model.applicationId);
            journeyId(model.journeyId);
            nextToken(model.nextToken);
            pageSize(model.pageSize);
            runId(model.runId);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getJourneyId() {
            return journeyId;
        }

        public final void setJourneyId(String journeyId) {
            this.journeyId = journeyId;
        }

        @Override
        public final Builder journeyId(String journeyId) {
            this.journeyId = journeyId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getPageSize() {
            return pageSize;
        }

        public final void setPageSize(String pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(String pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetJourneyRunExecutionMetricsRequest build() {
            return new GetJourneyRunExecutionMetricsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
